/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.io.RandomAccessFile;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.dimarray.DimArray;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;

public abstract class DataInfo {
    protected String fileName;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected Dimension tDim = null;
    protected Dimension xDim = null;
    protected Dimension yDim = null;
    protected Dimension zDim = null;
    protected boolean xReverse = false;
    protected boolean yReverse = false;
    protected boolean isGlobal = false;
    protected double missingValue = -9999.0;
    protected ProjectionInfo projInfo;
    protected MeteoDataType meteoDataType;

    public DataInfo() {
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> value) {
        this.variables = value;
    }

    public List<Variable> getPlottableVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable var : this.variables) {
            if (!var.isPlottable()) continue;
            vars.add(var);
        }
        return vars;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dims) {
        this.dimensions = dims;
    }

    public int getVariableNum() {
        return this.variables.size();
    }

    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable var : this.variables) {
            names.add(var.getName());
        }
        return names;
    }

    public List<LocalDateTime> getTimes() {
        if (this.tDim == null) {
            return null;
        }
        Array values = this.tDim.getDimValue();
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
        int i = 0;
        while ((long)i < values.getSize()) {
            times.add(JDateUtil.fromOADate((double)values.getDouble(i)));
            ++i;
        }
        return times;
    }

    public LocalDateTime getTime(int timeIdx) {
        if (this.tDim == null) {
            return null;
        }
        return JDateUtil.fromOADate((double)this.tDim.getDimValue().getDouble(timeIdx));
    }

    public double getTimeValue(int timeIdx) {
        if (this.tDim == null) {
            return Double.NaN;
        }
        return this.tDim.getDimValue().getDouble(timeIdx);
    }

    public static int getTimeValue(LocalDateTime time, LocalDateTime baseDate, String tDelta) {
        int value = 0;
        switch (tDelta.toLowerCase()) {
            case "seconds": {
                value = (int)Duration.between(baseDate, time).getSeconds();
                break;
            }
            case "minutes": {
                value = (int)Duration.between(baseDate, time).toMinutes();
                break;
            }
            case "hours": {
                value = (int)Duration.between(baseDate, time).toHours();
                break;
            }
            case "days": {
                value = Period.between(baseDate.toLocalDate(), time.toLocalDate()).getDays();
            }
        }
        return value;
    }

    public List<Integer> getTimeValues(LocalDateTime baseDate, String tDelta) {
        List<LocalDateTime> times = this.getTimes();
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (LocalDateTime time : times) {
            if (tDelta.equalsIgnoreCase("hours")) {
                values.add((int)Duration.between(baseDate, time).toHours());
                continue;
            }
            if (!tDelta.equalsIgnoreCase("days")) continue;
            values.add(Period.between(baseDate.toLocalDate(), time.toLocalDate()).getDays());
        }
        return values;
    }

    public void setTimes(List<LocalDateTime> value) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (LocalDateTime t : value) {
            values.add(JDateUtil.toOADate((LocalDateTime)t));
        }
        if (this.tDim == null) {
            this.tDim = new Dimension(DimensionType.T);
        }
        this.tDim.setValues(values);
    }

    public int getTimeNum() {
        if (this.tDim == null) {
            return 0;
        }
        return this.tDim.getLength();
    }

    public Dimension getTimeDimension() {
        return this.tDim;
    }

    public void setTimeDimension(Dimension tDim) {
        this.tDim = tDim;
    }

    public Dimension getXDimension() {
        return this.xDim;
    }

    public void setXDimension(Dimension xDim) {
        this.xDim = xDim;
    }

    public Dimension getYDimension() {
        return this.yDim;
    }

    public void setYDimension(Dimension yDim) {
        this.yDim = yDim;
    }

    public Dimension getZDimension() {
        return this.zDim;
    }

    public void setZDimension(Dimension zDim) {
        this.zDim = zDim;
    }

    public boolean isXReverse() {
        return this.xReverse;
    }

    public void setXReverse(boolean value) {
        this.xReverse = value;
    }

    public boolean isYReverse() {
        return this.yReverse;
    }

    public void setYReverse(boolean value) {
        this.yReverse = value;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean value) {
        this.isGlobal = value;
    }

    public double getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    public ProjectionInfo getProjectionInfo() {
        return this.projInfo;
    }

    public void setProjectionInfo(ProjectionInfo value) {
        this.projInfo = value;
    }

    public MeteoDataType getDataType() {
        return this.meteoDataType;
    }

    public void setDataType(MeteoDataType value) {
        this.meteoDataType = value;
    }

    public abstract boolean isValidFile(RandomAccessFile var1);

    public abstract void readDataInfo(String var1);

    public void readDataInfo(String fileName, boolean keepOpen) {
    }

    public String generateInfoText() {
        String dataInfo;
        block7: {
            Dimension dim;
            Attribute aAttS;
            Dimension ydim;
            int i;
            dataInfo = "File Name: " + this.getFileName();
            dataInfo = dataInfo + System.getProperty("line.separator") + "Dimensions: " + this.dimensions.size();
            for (i = 0; i < this.dimensions.size(); ++i) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this.dimensions.get(i).getShortName() + " = " + String.valueOf(this.dimensions.get(i).getLength()) + ";";
            }
            Dimension xdim = this.getXDimension();
            if (xdim != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "X Dimension: Xmin = " + String.valueOf(xdim.getMinValue()) + "; Xmax = " + String.valueOf(xdim.getMaxValue()) + "; Xsize = " + String.valueOf(xdim.getLength()) + "; Xdelta = " + String.valueOf(xdim.getDeltaValue());
            }
            if ((ydim = this.getYDimension()) != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "Y Dimension: Ymin = " + String.valueOf(ydim.getMinValue()) + "; Ymax = " + String.valueOf(ydim.getMaxValue()) + "; Ysize = " + String.valueOf(ydim.getLength()) + "; Ydelta = " + String.valueOf(ydim.getDeltaValue());
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Global Attributes: ";
            for (i = 0; i < this.attributes.size(); ++i) {
                aAttS = this.attributes.get(i);
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t: " + aAttS.toString();
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Variations: " + this.variables.size();
            for (i = 0; i < this.variables.size(); ++i) {
                int j;
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this.variables.get(i).getDataType().toString() + " " + this.variables.get(i).getShortName() + "(";
                List<Dimension> dims = this.variables.get(i).getDimensions();
                for (j = 0; j < dims.size(); ++j) {
                    dataInfo = dataInfo + dims.get(j).getShortName() + ",";
                }
                dataInfo = dataInfo.substring(0, dataInfo.length() - 1);
                dataInfo = dataInfo + ");";
                List<Attribute> atts = this.variables.get(i).getAttributes();
                for (j = 0; j < atts.size(); ++j) {
                    aAttS = atts.get(j);
                    dataInfo = dataInfo + System.getProperty("line.separator") + "\t\t" + this.variables.get(i).getShortName() + ": " + aAttS.toString();
                }
            }
            Iterator<Dimension> iterator = this.dimensions.iterator();
            if (!iterator.hasNext() || !(dim = iterator.next()).isUnlimited()) break block7;
            dataInfo = dataInfo + System.getProperty("line.separator") + "Unlimited dimension: " + dim.getShortName();
        }
        return dataInfo;
    }

    public abstract Array read(String var1);

    public DimArray readDimArray(String varName) {
        Variable variable = this.getVariable(varName);
        if (variable == null) {
            System.out.println("The variable is not exist: " + varName);
            return null;
        }
        Array array = this.read(varName);
        return new DimArray(array, variable.getDimensions());
    }

    public abstract Array read(String var1, int[] var2, int[] var3, int[] var4);

    public DimArray readDimArray(String varName, int[] origin, int[] size, int[] stride) {
        Variable variable = this.getVariable(varName);
        if (variable == null) {
            System.out.println("The variable is not exist: " + varName);
            return null;
        }
        Array array = this.read(varName, origin, size, stride).reduce();
        ArrayMath.missingToNaN((Array)array, (Number)this.missingValue);
        try {
            List<Dimension> dimensions = variable.sectionDimensions(origin, size, stride);
            return new DimArray(array, dimensions);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return new DimArray(array);
        }
    }

    public DimArray readDimArray(String varName, List<Range> ranges) {
        int n = ranges.size();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        ArrayMath.rangesToSection(ranges, (int[])origin, (int[])size, (int[])stride);
        return this.readDimArray(varName, origin, size, stride);
    }

    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }

    public Variable getVariable(String varName) {
        Variable v = null;
        for (Variable var : this.variables) {
            if (!var.getName().equalsIgnoreCase(varName)) continue;
            v = var;
            break;
        }
        if (v == null) {
            for (Variable var : this.variables) {
                if (!var.getShortName().equalsIgnoreCase(varName)) continue;
                v = var;
                break;
            }
        }
        return v;
    }

    public int getVariableIndex(String varName) {
        int varIdx = -1;
        int i = 0;
        for (Variable var : this.variables) {
            if (var.getName().equalsIgnoreCase(varName)) {
                varIdx = i;
                break;
            }
            ++i;
        }
        if (varIdx < 0) {
            i = 0;
            for (Variable var : this.variables) {
                if (var.getShortName().equalsIgnoreCase(varName)) {
                    varIdx = i;
                    break;
                }
                ++i;
            }
        }
        return varIdx;
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
    }

    public void addDimension(Dimension dim) {
        this.dimensions.add(dim);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public Attribute findGlobalAttribute(String attName) {
        for (Attribute att : this.attributes) {
            if (!att.getShortName().equalsIgnoreCase(attName)) continue;
            return att;
        }
        return null;
    }

    public boolean isRadial() {
        String va;
        Attribute ra = this.findGlobalAttribute("featureType");
        return ra != null && (va = ra.getStringValue()).equalsIgnoreCase("RADIAL");
    }
}

