/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

public enum ShapeTypes {
    POINT(1),
    POLYLINE(3),
    POLYGON(5),
    POINT_Z(11),
    POLYLINE_Z(13),
    POLYGON_Z(15),
    POINT_M(21),
    POLYLINE_M(23),
    POLYGON_M(25),
    WIND_ARROW(41),
    WIND_BARB(42),
    WEATHER_SYMBOL(43),
    STATION_MODEL(44),
    IMAGE(99),
    RECTANGLE(51),
    CURVE_LINE(52),
    CURVE_POLYGON(53),
    ELLIPSE(54),
    CIRCLE(55),
    BAR(56),
    POLYLINE_ERROR(57),
    ARC(58),
    TEXT(59),
    TEXTURE(60),
    CUBIC(61),
    CYLINDER(62),
    CONE(63),
    SPHERE(64);

    private final int value;

    public int getValue() {
        return this.value;
    }

    private ShapeTypes(int value) {
        this.value = value;
    }

    public static ShapeTypes valueOf(int ordinal) {
        switch (ordinal) {
            case 1: {
                return POINT;
            }
            case 3: {
                return POLYLINE;
            }
            case 5: {
                return POLYGON;
            }
            case 11: {
                return POINT_Z;
            }
            case 13: {
                return POLYLINE_Z;
            }
            case 15: {
                return POLYGON_Z;
            }
            case 21: {
                return POINT_M;
            }
            case 23: {
                return POLYLINE_M;
            }
            case 25: {
                return POLYGON_M;
            }
            case 41: {
                return WIND_ARROW;
            }
            case 42: {
                return WIND_BARB;
            }
            case 43: {
                return WEATHER_SYMBOL;
            }
            case 44: {
                return STATION_MODEL;
            }
            case 51: {
                return RECTANGLE;
            }
            case 52: {
                return CURVE_LINE;
            }
            case 53: {
                return CURVE_POLYGON;
            }
            case 54: {
                return ELLIPSE;
            }
            case 55: {
                return CIRCLE;
            }
            case 99: {
                return IMAGE;
            }
        }
        throw new IndexOutOfBoundsException("Invalid ordinal");
    }

    public static ShapeTypes valueOfBack(String name) {
        switch (name.toUpperCase()) {
            case "POINTM": {
                return POINT_M;
            }
            case "POINTZ": {
                return POINT_Z;
            }
            case "POLYLINEM": {
                return POLYLINE_M;
            }
            case "POLYLINEZ": {
                return POLYLINE_Z;
            }
            case "POLYGONM": {
                return POLYGON_M;
            }
            case "POLYGONZ": {
                return POLYGON_Z;
            }
            case "CURVELINE": {
                return CURVE_LINE;
            }
            case "CURVEPOLYGON": {
                return CURVE_POLYGON;
            }
            case "POLYLINEERROR": {
                return POLYLINE_ERROR;
            }
            case "STATIONMODEL": {
                return STATION_MODEL;
            }
            case "WEATHERSYMBOL": {
                return WEATHER_SYMBOL;
            }
            case "WINDARROR": {
                return WIND_ARROW;
            }
            case "WINDBARB": {
                return WIND_BARB;
            }
        }
        return ShapeTypes.valueOf(name.toUpperCase());
    }

    public boolean isPoint() {
        switch (this) {
            case POINT: 
            case POINT_M: 
            case POINT_Z: 
            case WIND_ARROW: 
            case WIND_BARB: 
            case WEATHER_SYMBOL: 
            case STATION_MODEL: {
                return true;
            }
        }
        return false;
    }

    public boolean isLine() {
        switch (this) {
            case POLYLINE: 
            case POLYLINE_Z: 
            case POLYLINE_M: 
            case CURVE_LINE: {
                return true;
            }
        }
        return false;
    }

    public boolean isPolygon() {
        switch (this) {
            case POLYGON: 
            case POLYGON_M: 
            case POLYGON_Z: 
            case RECTANGLE: 
            case CURVE_POLYGON: 
            case ELLIPSE: 
            case CIRCLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isSameLegendType(ShapeTypes st) {
        if (this == st) {
            return true;
        }
        if (this.isLine() && st.isLine()) {
            return true;
        }
        if (this.isPoint() && st.isPoint()) {
            return true;
        }
        return this.isPolygon() && st.isPolygon();
    }

    public boolean isZ() {
        switch (this) {
            case POINT_Z: 
            case POLYLINE_Z: 
            case POLYGON_Z: {
                return true;
            }
        }
        return false;
    }
}

