fn = os.path.join(migl.get_sample_folder(), 'MICAPS', '10101420.000')
f = addfile_micaps(fn)
lon = f['Longitude'][:]
lat = f['Latitude'][:]
temp = f['Temperature'][:]
dp = f['DewPoint'][:]
rh = meteo.relative_humidity_from_dewpoint(temp, dp)

#Plot
axesm()
geoshow('country', edgecolor='k')
levs = arange(0.1, 1.1, 0.1)
layer = scatter(lon, lat, rh, levs, edge=False, zorder=0)
colorbar(layer, ticks=levs,
    ticklabels=['%i%%' % (v*100) for v in levs])
title(u'相对湿度', fontname=u'黑体')