/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.meteoinfo.chart.graphic.cylinder.Cylinder;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.WindArrow3D;
import org.meteoinfo.math.Matrix4f;

public class QuiverRender
extends JOGLGraphicRender {
    private GraphicCollection3D graphics;
    private Program program;
    private IntBuffer vbo;
    private int quiverNumber;
    private float lineWidth;
    private float[] vertexPosition;
    private float[] vertexColor;
    private int sizePosition;
    private int sizeColor;
    private IntBuffer vboCone;
    private Cylinder arrow;
    private float[] coneVertexPosition;
    private float[] coneVertexNormal;
    private float[] coneVertexColor;
    private int[] coneVertexIndices;
    private int sizeConePosition;
    private int sizeConeNormal;
    private int sizeConeColor;

    public QuiverRender(GL2 gl) {
        super(gl);
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public QuiverRender(GL2 gl, GraphicCollection3D graphics) {
        this(gl);
        this.graphics = graphics;
        this.quiverNumber = graphics.getNumGraphics();
        PointBreak pb = (PointBreak)graphics.getGraphicN(0).getLegend();
        this.lineWidth = pb.getOutlineSize();
    }

    private void updateVertexArrays() {
        this.vertexPosition = new float[this.quiverNumber * 6];
        this.vertexColor = new float[this.quiverNumber * 8];
        ArrayList<Vector3f> vertexPositionList = new ArrayList<Vector3f>();
        ArrayList<Vector3f> vertexNormalList = new ArrayList<Vector3f>();
        ArrayList<Vector4f> vertexColorList = new ArrayList<Vector4f>();
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        Cylinder cylinder = null;
        int i = 0;
        int pi = 0;
        int ci = 0;
        while (i < this.quiverNumber) {
            Graphic graphic = this.graphics.getGraphicN(i);
            WindArrow3D shape = (WindArrow3D)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            PointZ sp = (PointZ)shape.getPoint();
            PointZ ep = shape.getEndPoint();
            Vector3f v1 = this.transform.transform((float)sp.X, (float)sp.Y, (float)sp.Z);
            Vector3f v2 = this.transform.transform((float)ep.X, (float)ep.Y, (float)ep.Z);
            float[] color = pb.getColor().getRGBComponents(null);
            this.vertexPosition[pi] = v1.x;
            this.vertexPosition[pi + 1] = v1.y;
            this.vertexPosition[pi + 2] = v1.z;
            this.vertexPosition[pi + 3] = v2.x;
            this.vertexPosition[pi + 4] = v2.y;
            this.vertexPosition[pi + 5] = v2.z;
            System.arraycopy(color, 0, this.vertexColor, ci, 4);
            System.arraycopy(color, 0, this.vertexColor, ci + 4, 4);
            if (cylinder == null) {
                cylinder = new Cylinder(shape.getHeadWidth() * 0.02f, 0.0f, shape.getHeadLength() * 0.02f, 8, 1, true);
            }
            Matrix4f matrix = new Matrix4f();
            matrix.lookAt(v2.sub((Vector3fc)v1, new Vector3f()));
            matrix.translate(v2);
            List<Vector3f> vertices = cylinder.getVertices();
            int n = vertices.size();
            int nAdded = vertexPositionList.size();
            for (Vector3f v : vertices) {
                vertexPositionList.add(matrix.mul(v));
            }
            List<Vector3f> normals = cylinder.getNormals();
            vertexNormalList.addAll(normals);
            for (int j = 0; j < n; ++j) {
                vertexColorList.add(new Vector4f(color));
            }
            if (nAdded == 0) {
                vertexIndices.addAll(cylinder.getIndices());
            } else {
                for (int idx : cylinder.getIndices()) {
                    vertexIndices.add(idx + nAdded);
                }
            }
            ++i;
            pi += 6;
            ci += 8;
        }
        int n = vertexPositionList.size();
        this.coneVertexPosition = new float[n * 3];
        this.coneVertexNormal = new float[n * 3];
        this.coneVertexColor = new float[n * 4];
        int i2 = 0;
        int j = 0;
        int k = 0;
        while (i2 < n) {
            Vector3f v = (Vector3f)vertexPositionList.get(i2);
            this.coneVertexPosition[j] = v.x;
            this.coneVertexPosition[j + 1] = v.y;
            this.coneVertexPosition[j + 2] = v.z;
            v = (Vector3f)vertexNormalList.get(i2);
            this.coneVertexNormal[j] = v.x;
            this.coneVertexNormal[j + 1] = v.y;
            this.coneVertexNormal[j + 2] = v.z;
            Vector4f v4 = (Vector4f)vertexColorList.get(i2);
            this.coneVertexColor[k] = v4.x;
            this.coneVertexColor[k + 1] = v4.y;
            this.coneVertexColor[k + 2] = v4.z;
            this.coneVertexColor[k + 3] = v4.w;
            ++i2;
            j += 3;
            k += 4;
        }
        this.coneVertexIndices = vertexIndices.stream().mapToInt(Integer::intValue).toArray();
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/surface/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/surface/surface.frag");
        this.program = new Program("surface", vertexShaderCode, fragmentShaderCode);
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (updateBuffer) {
            this.updateVertexArrays();
            FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexPosition);
            this.sizePosition = vertexBuffer.capacity() * 4;
            FloatBuffer colorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexColor);
            this.sizeColor = colorBuffer.capacity() * 4;
            int totalSize = this.sizePosition + this.sizeColor;
            this.vbo = GLBuffers.newDirectIntBuffer((int)1);
            this.gl.glGenBuffers(1, this.vbo);
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBufferData(34962, (long)totalSize, null, 35044);
            this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
            this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeColor, (Buffer)colorBuffer);
            this.gl.glBindBuffer(34962, 0);
            FloatBuffer coneVertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexPosition);
            this.sizeConePosition = coneVertexBuffer.capacity() * 4;
            FloatBuffer coneNormalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexNormal);
            this.sizeConeNormal = coneNormalBuffer.capacity() * 4;
            FloatBuffer coneColorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexColor);
            this.sizeConeColor = coneColorBuffer.capacity() * 4;
            this.vboCone = GLBuffers.newDirectIntBuffer((int)2);
            this.gl.glGenBuffers(2, this.vboCone);
            this.gl.glBindBuffer(34962, this.vboCone.get(0));
            this.gl.glBufferData(34962, (long)(this.sizeConePosition + this.sizeConeNormal + this.sizeConeColor), null, 35044);
            this.gl.glBufferSubData(34962, 0L, (long)this.sizeConePosition, (Buffer)coneVertexBuffer);
            this.gl.glBufferSubData(34962, (long)this.sizeConePosition, (long)this.sizeConeNormal, (Buffer)coneNormalBuffer);
            this.gl.glBufferSubData(34962, (long)(this.sizeConePosition + this.sizeConeNormal), (long)this.sizeConeColor, (Buffer)coneColorBuffer);
            this.gl.glBindBuffer(34962, 0);
            IntBuffer coneIndexBuffer = GLBuffers.newDirectIntBuffer((int[])this.coneVertexIndices);
            this.gl.glBindBuffer(34963, this.vboCone.get(1));
            this.gl.glBufferData(34963, (long)(coneIndexBuffer.capacity() * 4), (Buffer)coneIndexBuffer, 35044);
            this.gl.glBindBuffer(34963, 0);
        }
    }

    void setUniforms() {
    }

    @Override
    public void draw() {
        this.gl.glPushMatrix();
        FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
        this.gl.glLoadMatrixf(this.modelViewMatrixR.get(fb));
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)this.sizePosition);
            boolean lightEnabled = this.lighting.isEnable();
            if (lightEnabled) {
                this.lighting.stop(this.gl);
            }
            this.gl.glLineWidth(this.lineWidth * this.dpiScale);
            this.gl.glDrawArrays(1, 0, this.quiverNumber * 2);
            if (lightEnabled) {
                this.lighting.start(this.gl);
            }
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32886);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glBindBuffer(34962, this.vboCone.get(0));
            this.gl.glBindBuffer(34963, this.vboCone.get(1));
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32885);
            this.gl.glNormalPointer(5126, 0, (long)this.sizeConePosition);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)(this.sizeConePosition + this.sizeConeNormal));
            this.gl.glDrawElements(4, this.coneVertexIndices.length, 5125, 0L);
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32885);
            this.gl.glDisableClientState(32886);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glBindBuffer(34963, 0);
        }
        this.gl.glPopMatrix();
    }
}

