/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.meteoinfo.chart.graphic.TriMeshGraphic;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.legend.PolygonBreak;

public class TriMeshRender
extends JOGLGraphicRender {
    private TriMeshGraphic meshGraphic;
    private IntBuffer vbo;
    private Program program;
    private float[] vertexPosition;
    private int sizePosition;
    private int sizeNormal;
    private int sizeColor;

    public TriMeshRender(GL2 gl) {
        super(gl);
        this.useShader = false;
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initVertexBuffer();
    }

    public TriMeshRender(GL2 gl, TriMeshGraphic meshGraphic) {
        this(gl);
        this.meshGraphic = meshGraphic;
        this.setBufferData();
    }

    private void initVertexBuffer() {
        this.vbo = GLBuffers.newDirectIntBuffer((int)2);
    }

    private void setBufferData() {
        if (this.vertexPosition == null) {
            this.vertexPosition = this.meshGraphic.getVertexPosition();
        }
        FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexPosition);
        if (this.meshGraphic.getVertexNormal() == null) {
            this.meshGraphic.calculateNormalVectors(this.vertexPosition);
        }
        FloatBuffer normalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.meshGraphic.getVertexNormal());
        FloatBuffer colorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.meshGraphic.getVertexColor());
        this.sizePosition = vertexBuffer.capacity() * 4;
        this.sizeNormal = normalBuffer.capacity() * 4;
        this.sizeColor = colorBuffer.capacity() * 4;
        this.gl.glGenBuffers(2, this.vbo);
        this.gl.glBindBuffer(34962, this.vbo.get(0));
        this.gl.glBufferData(34962, (long)(this.sizePosition + this.sizeNormal + this.sizeColor), null, 35044);
        this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
        this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeNormal, (Buffer)normalBuffer);
        this.gl.glBufferSubData(34962, (long)(this.sizePosition + this.sizeNormal), (long)this.sizeColor, (Buffer)colorBuffer);
        this.gl.glBindBuffer(34962, 0);
        IntBuffer indexBuffer = GLBuffers.newDirectIntBuffer((int[])this.meshGraphic.getVertexIndices());
        this.gl.glBindBuffer(34963, this.vbo.get(1));
        this.gl.glBufferData(34963, (long)(indexBuffer.capacity() * 4), (Buffer)indexBuffer, 35044);
        this.gl.glBindBuffer(34963, 0);
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (alwaysUpdateBuffers) {
            this.setBufferData();
        }
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/mesh/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/mesh/mesh.frag");
        this.program = new Program("mesh", vertexShaderCode, fragmentShaderCode);
    }

    public void updateShaders() {
        if (this.program == null) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void setUniforms() {
        this.program.allocateUniform(this.gl, "matrixModelViewProjection", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.viewProjMatrix.get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "matrixModelView", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).get(Buffers.newDirectFloatBuffer((int)16))));
        Matrix4f matrixNormal = this.toMatrix(this.mvmatrix);
        matrixNormal.setColumn(3, (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        this.program.allocateUniform(this.gl, "matrixNormal", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, matrixNormal.get(Buffers.newDirectFloatBuffer((int)16))));
        float[] rgba = this.meshGraphic.getColor().getRGBComponents(null);
        this.program.allocateUniform(this.gl, "color", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 1, rgba, 0));
        this.program.allocateUniform(this.gl, "lightPosition", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 1, this.lighting.getPosition(), 0));
        this.program.allocateUniform(this.gl, "lightAmbient", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 1, this.lighting.getAmbient(), 0));
        this.program.allocateUniform(this.gl, "lightDiffuse", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 1, this.lighting.getDiffuse(), 0));
        this.program.allocateUniform(this.gl, "lightSpecular", (gl2, loc) -> gl2.glUniform4fv(loc.intValue(), 1, this.lighting.getSpecular(), 0));
        this.program.setUniforms(this.gl);
    }

    @Override
    public void draw() {
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            int attribVertexPosition = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexPosition");
            int attribVertexNormal = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexNormal");
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableVertexAttribArray(attribVertexPosition);
            this.gl.glEnableVertexAttribArray(attribVertexNormal);
            this.gl.glVertexAttribPointer(attribVertexPosition, 3, 5126, false, 0, 0L);
            this.gl.glVertexAttribPointer(attribVertexNormal, 3, 5126, false, 0, (long)(this.vertexPosition.length * 4));
            this.gl.glDrawArrays(4, 0, this.meshGraphic.getVertexNumber());
            this.gl.glDisableVertexAttribArray(attribVertexPosition);
            this.gl.glDisableVertexAttribArray(attribVertexNormal);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBindBuffer(34963, this.vbo.get(1));
            this.gl.glEnableClientState(32885);
            this.gl.glEnableClientState(32884);
            this.gl.glNormalPointer(5126, 0, (long)this.sizePosition);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)(this.sizePosition + this.sizeNormal));
            PolygonBreak pb = (PolygonBreak)this.meshGraphic.getLegendScheme().getLegendBreak(0);
            if (pb.isDrawFill()) {
                this.gl.glEnable(32823);
                this.gl.glPolygonOffset(1.0f, 1.0f);
                if (this.meshGraphic.isFaceInterp()) {
                    this.gl.glDrawElements(4, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                } else {
                    this.gl.glShadeModel(7424);
                    this.gl.glDrawElements(4, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                    this.gl.glShadeModel(7425);
                }
            }
            if (pb.isDrawOutline()) {
                boolean lightEnabled = this.lighting.isEnable();
                if (lightEnabled) {
                    this.lighting.stop(this.gl);
                }
                this.gl.glLineWidth(pb.getOutlineSize() * this.dpiScale);
                if (!this.meshGraphic.isMesh()) {
                    this.gl.glDisableClientState(32886);
                    float[] rgba = pb.getOutlineColor().getRGBComponents(null);
                    this.gl.glColor4fv(rgba, 0);
                }
                this.gl.glPolygonMode(1032, 6913);
                this.gl.glDrawElements(4, this.meshGraphic.getVertexIndices().length, 5125, 0L);
                this.gl.glPolygonMode(1032, 6914);
                if (lightEnabled) {
                    this.lighting.start(this.gl);
                }
            }
            this.gl.glDisableClientState(32885);
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32886);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glBindBuffer(34963, 0);
        }
    }

    public void draw_bak() {
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            int attribVertexPosition = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexPosition");
            int attribVertexNormal = this.gl.glGetAttribLocation(this.program.getProgramId().intValue(), "vertexNormal");
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableVertexAttribArray(attribVertexPosition);
            this.gl.glEnableVertexAttribArray(attribVertexNormal);
            this.gl.glVertexAttribPointer(attribVertexPosition, 3, 5126, false, 0, 0L);
            this.gl.glVertexAttribPointer(attribVertexNormal, 3, 5126, false, 0, (long)(this.vertexPosition.length * 4));
            this.gl.glDrawArrays(4, 0, this.meshGraphic.getVertexNumber());
            this.gl.glDisableVertexAttribArray(attribVertexPosition);
            this.gl.glDisableVertexAttribArray(attribVertexNormal);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glUseProgram(0);
        } else {
            float[] rgba = this.meshGraphic.getColor().getRGBComponents(null);
            this.gl.glColor4fv(rgba, 0);
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableClientState(32885);
            this.gl.glEnableClientState(32884);
            this.gl.glNormalPointer(5126, 0, (long)(this.vertexPosition.length * 4));
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            PolygonBreak pb = (PolygonBreak)this.meshGraphic.getLegendBreak();
            if (pb.isDrawFill()) {
                this.gl.glEnable(32823);
                this.gl.glPolygonOffset(1.0f, 1.0f);
                this.gl.glDrawArrays(4, 0, this.meshGraphic.getVertexNumber());
            }
            if (pb.isDrawOutline()) {
                boolean lightEnabled = this.lighting.isEnable();
                if (lightEnabled) {
                    this.lighting.stop(this.gl);
                }
                rgba = pb.getOutlineColor().getRGBComponents(null);
                this.gl.glColor4fv(rgba, 0);
                this.gl.glPolygonMode(1032, 6913);
                this.gl.glDrawArrays(4, 0, this.meshGraphic.getVertexNumber());
                this.gl.glPolygonMode(1032, 6914);
                if (lightEnabled) {
                    this.lighting.start(this.gl);
                }
            }
            this.gl.glDisableClientState(32885);
            this.gl.glDisableClientState(32884);
            this.gl.glBindBuffer(34962, 0);
        }
    }
}

