/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.Calibrator;

public class CalibratorDefault
implements Calibrator {
    protected static int curCalType = 0;
    public boolean isPreCalibrated = false;

    public CalibratorDefault(DataInputStream dis, AncillaryData ad) throws IOException {
    }

    @Override
    public int setCalType(int calType) {
        if (calType < 1 || calType > 5) {
            return -1;
        }
        curCalType = calType;
        return 0;
    }

    @Override
    public float[] calibrate(float[] inputData, int band, int calTypeOut) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.calibrate(inputData[i], band, calTypeOut);
        }
        return outputData;
    }

    @Override
    public float calibrate(float inputPixel, int band, int calTypeOut) {
        float outputData = 0.0f;
        switch (curCalType) {
            case 1: {
                outputData = inputPixel;
                break;
            }
            case 2: {
                outputData = inputPixel;
                break;
            }
            case 3: {
                outputData = inputPixel;
                break;
            }
            case 4: {
                outputData = inputPixel;
                break;
            }
            case 5: {
                outputData = inputPixel;
            }
        }
        return outputData;
    }

    @Override
    public int[] calibratedList(int band, boolean isPreCal) {
        int[] cList = new int[]{1, 5};
        return cList;
    }

    @Override
    public String calibratedUnit(int calType) {
        return null;
    }

    @Override
    public float convertBritToTemp(int inVal) {
        int con1 = 418;
        int con2 = 660;
        int ilim = 176;
        float outVal = inVal > ilim ? (float)(con1 - inVal) : (float)((con2 - inVal) / 2);
        return outVal;
    }

    @Override
    public float[] convertBritToTemp(float[] inputData) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.convertBritToTemp((int)inputData[i]);
        }
        return outputData;
    }

    @Override
    public boolean getIsPreCalibrated() {
        return this.isPreCalibrated;
    }

    @Override
    public void setIsPreCalibrated(boolean isPrecalibrated) {
        this.isPreCalibrated = isPrecalibrated;
    }
}

