/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dimarray;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ndarray.util.BigDecimalUtil;

public class Dimension {
    private String name;
    private DimensionType dimType;
    private Array dimValue;
    private int dimId;
    private boolean unlimited = false;
    private boolean variableLength = false;
    private boolean shared = true;
    private boolean reverse = false;
    private String unit = "null";
    private boolean stagger = false;

    public Dimension() {
        this("null", 1);
    }

    public Dimension(int len) {
        this("null", len);
    }

    public Dimension(String name, int len) {
        this.name = name;
        this.dimType = DimensionType.OTHER;
        this.dimValue = ArrayUtil.arrayRange((Number)0, (Number)len, (Number)1);
    }

    public Dimension(DimensionType dimType) {
        this(dimType.toString().toLowerCase(), 1, dimType);
    }

    public Dimension(String name, Array dimValue, DimensionType dimType) {
        this.name = name;
        this.dimType = dimType;
        this.dimValue = dimValue.copyIfView();
    }

    public Dimension(String name, Array dimValue) {
        this(name, dimValue, DimensionType.OTHER);
    }

    public Dimension(String name, DimensionType dimType) {
        this.name = name;
        this.dimType = dimType;
    }

    public Dimension(String name, int len, DimensionType dimType) {
        this(name, len);
        this.dimType = dimType;
    }

    public Dimension(String name, int len, DimensionType dimType, double min, double delta) {
        this(name, len);
        this.dimType = dimType;
        this.dimValue = ArrayUtil.arrayRange1((Number)min, (int)len, (Number)delta);
    }

    public Dimension(Dimension dimension) {
        this.name = dimension.getName();
        this.dimId = dimension.getDimId();
        this.unit = dimension.getUnit();
        this.dimType = dimension.getDimType();
        this.stagger = dimension.isStagger();
        this.unlimited = dimension.isUnlimited();
    }

    public String getShortName() {
        return this.name;
    }

    public void setShortName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int getLength() {
        return (int)this.dimValue.getSize();
    }

    public void setLength(int value) {
        if (value <= 0) {
            return;
        }
        if (this.dimValue == null || this.dimValue.getSize() != (long)value) {
            this.dimValue = ArrayUtil.arrayRange((Number)0, (Number)value, (Number)1);
        }
    }

    public DimensionType getDimType() {
        return this.dimType;
    }

    public void setDimType(DimensionType value) {
        this.dimType = value;
    }

    public Array getDimValue() {
        return this.dimValue;
    }

    public void setDimValue(Array value) {
        this.dimValue = value.copyIfView();
    }

    public double getDimValue(int idx) {
        return this.dimValue.getDouble(idx);
    }

    public List<Double> getDimValueList() {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while ((long)i < this.dimValue.getSize()) {
            values.add(this.dimValue.getDouble(i));
            ++i;
        }
        return values;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setDimId(int value) {
        this.dimId = value;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean value) {
        this.unlimited = value;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean value) {
        this.shared = value;
    }

    public boolean isVariableLength() {
        return this.variableLength;
    }

    public void setVariableLength(boolean value) {
        this.variableLength = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    public boolean isStagger() {
        return this.stagger;
    }

    public void setStagger(boolean value) {
        this.stagger = value;
    }

    public boolean equals(Dimension aDim) {
        if (!this.getShortName().equals(aDim.getShortName())) {
            return false;
        }
        if (this.dimType != aDim.getDimType()) {
            return false;
        }
        return this.getLength() == aDim.getLength();
    }

    public double[] getValues() {
        int len = this.getLength();
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.dimValue.getDouble(i);
        }
        return values;
    }

    public void setValues(List<Double> values) {
        this.dimValue = ArrayUtil.array(values);
    }

    public void setDimValues(List<Number> values) {
        this.dimValue = ArrayUtil.array(values);
    }

    public void setValue(LocalDateTime v) {
        this.dimValue = Array.factory((DataType)DataType.DATE, (int[])new int[]{1});
        this.dimValue.setDate(0, v);
    }

    public void setValue(double v) {
        this.dimValue = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{1});
        this.dimValue.setDouble(0, v);
    }

    public void setValues(double[] values) {
        this.dimValue = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{values.length}, (Object)values);
    }

    public void setValues(float[] values) {
        this.dimValue = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{values.length}, (Object)values);
    }

    public double getMinValue() {
        return this.dimValue.getDouble(0);
    }

    public double getMaxValue() {
        return this.dimValue.getDouble((int)this.dimValue.getSize() - 1);
    }

    public double getDeltaValue() {
        if (this.dimValue.getSize() <= 1L) {
            return 1.0;
        }
        return BigDecimalUtil.sub((double)this.dimValue.getDouble(1), (double)this.dimValue.getDouble(0));
    }

    public void flip() {
        this.dimValue = this.dimValue.flip(0).copy();
    }

    public Dimension extract(Range range) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(range);
        try {
            Array a = this.dimValue.section(ranges);
            Dimension dim = new Dimension(this.getShortName(), a, this.dimType);
            dim.setDimId(this.dimId);
            dim.setUnit(this.unit);
            dim.setStagger(this.stagger);
            return dim;
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension extract(int first, int last, int stride) {
        int n = (last - first) / stride + 1;
        Dimension dim = new Dimension(this.getShortName(), n, this.dimType);
        dim.setDimId(this.dimId);
        dim.setUnit(this.unit);
        dim.setStagger(this.stagger);
        if (this.dimValue.getSize() > (long)last) {
            int i;
            ArrayList<Object> values = new ArrayList<Object>();
            if (first <= last) {
                if (stride > 0) {
                    for (i = first; i <= last; i += stride) {
                        values.add(this.dimValue.getObject(i));
                    }
                } else {
                    for (i = last; i >= first; i += stride) {
                        values.add(this.dimValue.getObject(i));
                    }
                }
            } else if (stride > 0) {
                for (i = last; i <= first; i += stride) {
                    values.add(this.dimValue.getObject(i));
                }
            } else {
                for (i = first; i >= last; i += stride) {
                    values.add(this.dimValue.getObject(i));
                }
            }
            Array array = Array.factory((DataType)this.dimValue.getDataType(), (int[])new int[]{values.size()});
            for (int i2 = 0; i2 < values.size(); ++i2) {
                array.setObject(i2, values.get(i2));
            }
            dim.setDimValue(array);
        }
        return dim;
    }

    public Dimension extract(double first, double last, double stride) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this.dimType);
        dim.setDimId(this.dimId);
        dim.setUnit(this.unit);
        dim.setStagger(this.stagger);
        ArrayList<Object> values = new ArrayList<Object>();
        for (double v = first; v <= last; v += stride) {
            int idx = this.getValueIndex(v);
            values.add(this.dimValue.getObject(idx));
        }
        Array array = Array.factory((DataType)this.dimValue.getDataType(), (int[])new int[]{values.size()});
        for (int i = 0; i < values.size(); ++i) {
            array.setObject(i, values.get(i));
        }
        dim.setDimValue(array);
        return dim;
    }

    public Dimension extract(List<Integer> index) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this.dimType);
        dim.setDimId(this.dimId);
        dim.setUnit(this.unit);
        dim.setStagger(this.stagger);
        Array array = Array.factory((DataType)this.dimValue.getDataType(), (int[])new int[]{index.size()});
        for (int i = 0; i < index.size(); ++i) {
            array.setObject(i, this.dimValue.getObject(index.get(i).intValue()));
        }
        dim.setDimValue(array);
        return dim;
    }

    public Dimension extract(Array index) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this.dimType);
        dim.setDimId(this.dimId);
        dim.setUnit(this.unit);
        dim.setStagger(this.stagger);
        if (index.getDataType() == DataType.BOOLEAN) {
            int n = ArrayMath.sum((Array)index).intValue();
            Array values = Array.factory((DataType)this.dimValue.getDataType(), (int[])new int[]{n});
            IndexIterator iter = index.getIndexIterator();
            IndexIterator iterV = values.getIndexIterator();
            int i = 0;
            while (iter.hasNext()) {
                if (iter.getBooleanNext()) {
                    iterV.setObjectNext(this.dimValue.getObject(i));
                }
                ++i;
            }
            dim.setDimValue(values);
        } else {
            Array values = Array.factory((DataType)this.dimValue.getDataType(), (int[])new int[]{(int)index.getSize()});
            IndexIterator iter = index.getIndexIterator();
            IndexIterator iterV = values.getIndexIterator();
            while (iter.hasNext()) {
                iterV.setObjectNext(this.dimValue.getObject(iter.getIntNext()));
            }
            dim.setDimValue(values);
        }
        return dim;
    }

    public int getValueIndex(double v) {
        int idx;
        block4: {
            idx = ArrayMath.asList((Array)this.dimValue).indexOf(v);
            if (idx >= 0) break block4;
            idx = this.getLength() - 1;
            if (this.getDeltaValue() > 0.0) {
                for (int i = 0; i < this.getLength(); ++i) {
                    if (!(v <= this.dimValue.getDouble(i))) continue;
                    idx = i == 0 ? 0 : (this.dimValue.getDouble(i) - v > v - this.dimValue.getDouble(i - 1) ? i - 1 : i);
                    break;
                }
            } else {
                for (int i = 0; i < this.getLength(); ++i) {
                    if (!(v >= this.dimValue.getDouble(i))) continue;
                    idx = i == 0 ? 0 : (this.dimValue.getDouble(i - 1) - v > v - this.dimValue.getDouble(i) ? i : i - 1);
                    break;
                }
            }
        }
        return idx;
    }

    public boolean isAscending() {
        int i = 0;
        while ((long)i < this.dimValue.getSize() - 1L) {
            if (this.dimValue.getDouble(i) >= this.dimValue.getDouble(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDescending() {
        int i = 0;
        while ((long)i < this.dimValue.getSize() - 1L) {
            if (this.dimValue.getDouble(i) <= this.dimValue.getDouble(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOrdered() {
        return this.isAscending() || this.isDescending();
    }

    public void reverse() {
        this.dimValue = this.dimValue.flip(0).copy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getShortName());
        sb.append("\n");
        sb.append("Min value: ").append(String.valueOf(this.getMinValue()));
        sb.append("\n");
        sb.append("Max value: ").append(String.valueOf(this.getMaxValue()));
        sb.append("\n");
        sb.append("Size: ").append(String.valueOf(this.getLength()));
        sb.append("\n");
        sb.append("Delta: ").append(String.valueOf(this.getDeltaValue()));
        sb.append("\n");
        sb.append("Unit: ").append(this.unit);
        return sb.toString();
    }
}

