/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class DsgCollectionImpl
implements DsgFeatureCollection {
    protected String name;
    protected String timeName = "time";
    protected CalendarDateUnit timeUnit;
    protected String altName = "altitude";
    protected String altUnits;
    protected CollectionInfo info;
    protected List<CoordinateAxis> coordVars;
    protected List<Variable> extras;

    protected DsgCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        this.name = name;
        this.timeUnit = timeUnit;
        this.altUnits = altUnits;
    }

    protected DsgCollectionImpl(String name, List<CoordinateAxis> coordVars) {
        this.name = name;
        this.coordVars = coordVars;
        for (CoordinateAxis coord : coordVars) {
            if (coord.getAxisType().isTime()) {
                this.timeUnit = CalendarDateUnit.of(null, coord.getUnitsString());
                this.timeName = coord.getShortName();
                continue;
            }
            if (!coord.getAxisType().isVert()) continue;
            this.altUnits = coord.getUnitsString();
            this.altName = coord.getShortName();
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getTimeName() {
        return this.timeName;
    }

    @Override
    @Nullable
    public CalendarDateUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    @Nullable
    public String getAltName() {
        return this.altName;
    }

    @Override
    @Nullable
    public String getAltUnits() {
        return this.altUnits;
    }

    @Override
    @Nonnull
    public List<CoordinateAxis> getCoordinateVariables() {
        return this.coordVars;
    }

    @Override
    @Nonnull
    public List<Variable> getExtraVariables() {
        return this.extras == null ? new ArrayList() : this.extras;
    }

    @Override
    public int size() {
        return this.info == null ? -1 : this.info.nfeatures;
    }

    public int getNobs() {
        return this.info == null ? -1 : this.info.nobs;
    }

    @Override
    @Nullable
    public CalendarDateRange getCalendarDateRange() {
        return this.info == null ? null : this.info.getCalendarDateRange(this.timeUnit);
    }

    @Override
    @Nullable
    public LatLonRect getBoundingBox() {
        return this.info == null ? null : this.info.bbox;
    }

    @Nonnull
    public CollectionInfo getInfo() {
        if (this.info == null) {
            this.info = new CollectionInfo();
        }
        return this.info;
    }
}

