/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jdom2.Element;
import thredds.client.catalog.Catalog;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.internal.ncml.AggDatasetOuter;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.internal.ncml.AggregationOuter;
import ucar.nc2.internal.ncml.BuilderHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.xml.Parse;

class AggregationExisting
extends AggregationOuter {
    public static int countCacheUse;

    AggregationExisting(NetcdfDataset.Builder ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.joinExisting, recheckS);
    }

    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        AggDataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        BuilderHelper.transferDataset(typical, this.ncDataset, null);
        Group.Builder rootGroup = this.ncDataset.rootGroup;
        String dimName = this.getDimensionName();
        AggregationOuter.CoordValueVar coordCacheVar = null;
        if (this.type != Aggregation.Type.joinExistingOne) {
            Variable tcv = typical.findVariable(dimName);
            if (tcv != null) {
                coordCacheVar = new AggregationOuter.CoordValueVar(dimName, tcv.getDataType(), tcv.getUnitsString());
            } else {
                VariableDS.Builder fake = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(dimName)).setDataType(DataType.INT)).setParentGroupBuilder(rootGroup)).setDimensionsByName(dimName);
                fake.setAutoGen(0.0, 1.0);
                rootGroup.addVariable(fake);
                logger.warn("Adding a fake coord var for {}", (Object)dimName);
            }
        } else {
            DataType coordDataType = DataType.STRING;
            String coordUnits = "";
            if (typicalDataset instanceof AggDatasetOuter) {
                coordDataType = ((AggDatasetOuter)typicalDataset).coordDataType;
                coordUnits = ((AggDatasetOuter)typicalDataset).coordUdunit;
            }
            coordCacheVar = new AggregationOuter.CoordValueVar(dimName, coordDataType, coordUnits);
        }
        if (coordCacheVar != null) {
            this.cacheList.add(coordCacheVar);
        }
        this.persistRead();
        this.buildCoords(cancelTask);
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        rootGroup.removeDimension(dimName);
        rootGroup.addDimension(aggDim);
        this.promoteGlobalAttributes((AggDatasetOuter)typicalDataset);
        for (Variable v : typical.getVariables()) {
            String outerName;
            if (v.getRank() < 1 || !dimName.equals(outerName = v.getDimension(0).makeFullName())) continue;
            VariableDS.Builder vagg = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(v.getShortName())).setDataType(v.getDataType())).setParentGroupBuilder(rootGroup)).setDimensionsByName(v.getDimensionsString());
            vagg.setProxyReader(this);
            BuilderHelper.transferAttributes(v, vagg.getAttributeContainer());
            rootGroup.replaceVariable(vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        Optional<Variable.Builder<?>> joinAggCoordOpt = rootGroup.findVariableLocal(dimName);
        if (!joinAggCoordOpt.isPresent() && this.type == Aggregation.Type.joinExisting) {
            typicalDataset.close(typical);
            throw new IllegalArgumentException("No existing coordinate variable for joinExisting on " + this.getLocation());
        }
        VariableDS.Builder joinAggCoord = joinAggCoordOpt.orElse(null);
        if (this.type == Aggregation.Type.joinExistingOne) {
            joinAggCoordOpt.ifPresent(joinAgg -> rootGroup.removeVariable(joinAgg.shortName));
            DataType coordDataType = DataType.STRING;
            String coordUnits = "";
            if (typicalDataset instanceof AggDatasetOuter) {
                coordDataType = ((AggDatasetOuter)typicalDataset).coordDataType;
                coordUnits = ((AggDatasetOuter)typicalDataset).coordUdunit;
            }
            joinAggCoord = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(dimName)).setDataType(coordDataType)).setParentGroupBuilder(rootGroup)).setDimensionsByName(dimName);
            joinAggCoord.setProxyReader(this);
            rootGroup.addVariable(joinAggCoord);
            this.aggVars.add(joinAggCoord);
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
            joinAggCoord.addAttribute(new Attribute("long_name", "time coordinate"));
            joinAggCoord.addAttribute(new Attribute("standard_name", "time"));
            if (coordUnits != null && !coordUnits.equals("")) {
                joinAggCoord.addAttribute(new Attribute("units", coordUnits));
            }
        }
        if (this.timeUnitsChange && joinAggCoord != null) {
            this.readTimeCoordinates(joinAggCoord, cancelTask);
        }
        if (joinAggCoord != null) {
            joinAggCoord.setSPobject(coordCacheVar);
        }
        this.persistRead();
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        if (debugInvocation) {
            System.out.println(this.ncDataset.location + " invocation count = " + AggregationOuter.invocation);
        }
    }

    @Override
    public void persistWrite() throws IOException {
        File cacheFile;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        if (cacheName.startsWith("file:")) {
            cacheName = cacheName.substring(5);
        }
        if ((cacheFile = diskCache2.getCacheFile(cacheName)) == null) {
            throw new IllegalStateException();
        }
        if (!this.cacheDirty && cacheFile.exists()) {
            return;
        }
        File dir = cacheFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            logger.error("Cant make cache directory= " + cacheFile);
        }
        try (FileOutputStream fos = new FileOutputStream(cacheFile);
             FileChannel channel = fos.getChannel();
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));){
            FileLock lock;
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                if (out != null) {
                    if (var9_13 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                if (channel != null) {
                    if (var7_9 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
                if (fos != null) {
                    if (var5_5 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
                return;
            }
            if (lock == null) {
                return;
            }
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
            out.print("<aggregation xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' version='3' ");
            out.print("type='" + (Object)((Object)this.type) + "' ");
            if (this.dimName != null) {
                out.print("dimName='" + this.dimName + "' ");
            }
            if (this.datasetManager.getRecheck() != null) {
                out.print("recheckEvery='" + this.datasetManager.getRecheck() + "' ");
            }
            out.print(">\n");
            List<AggDataset> nestedDatasets = this.getDatasets();
            for (AggDataset dataset : nestedDatasets) {
                AggDatasetOuter dod = (AggDatasetOuter)dataset;
                if (dod.getId() == null) {
                    logger.warn("id is null");
                }
                out.print("  <netcdf id='" + dod.getId() + "' ");
                out.print("ncoords='" + dod.getNcoords(null) + "' >\n");
                for (AggregationOuter.CacheVar pv : this.cacheList) {
                    Array data = pv.getData(dod.getId());
                    if (data == null) continue;
                    out.print("    <cache varName='" + pv.varName + "' >");
                    while (data.hasNext()) {
                        out.printf("%s ", data.next());
                    }
                    out.print("</cache>\n");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(" wrote array = " + pv.varName + " nelems= " + data.getSize() + " for " + dataset.getLocation());
                }
                out.print("  </netcdf>\n");
            }
            out.print("</aggregation>\n");
            long time = this.datasetManager.getLastScanned();
            if (time == 0L) {
                time = System.currentTimeMillis();
            }
            if (!cacheFile.setLastModified(time)) {
                logger.warn("FAIL to set lastModified on {}", (Object)cacheFile.getPath());
            }
            this.cacheDirty = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Aggregation persisted = " + cacheFile.getPath() + " lastModified= " + new Date(this.datasetManager.getLastScanned()));
            }
        }
    }

    @Override
    protected void persistRead() {
        Element aggElem;
        File cacheFile;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        if (cacheName.startsWith("file:")) {
            cacheName = cacheName.substring(5);
        }
        if ((cacheFile = diskCache2.getCacheFile(cacheName)) == null) {
            throw new IllegalStateException();
        }
        if (!cacheFile.exists()) {
            return;
        }
        long lastWritten = cacheFile.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug(" Try to Read cache {} " + cacheFile.getPath());
        }
        try {
            aggElem = Parse.readRootElement("file:" + cacheFile.getPath());
        }
        catch (IOException e) {
            if (debugCache) {
                System.out.println(" No cache for " + cacheName + " - " + e.getMessage());
            }
            return;
        }
        String version = aggElem.getAttributeValue("version");
        if (!"3".equals(version)) {
            return;
        }
        HashMap<String, AggDataset> map = new HashMap<String, AggDataset>();
        for (AggDataset ds : this.getDatasets()) {
            map.put(ds.getId(), ds);
        }
        List ncList = aggElem.getChildren("netcdf", Catalog.ncmlNS);
        for (Element netcdfElemNested : ncList) {
            MFile mfile;
            String id = netcdfElemNested.getAttributeValue("id");
            AggDatasetOuter dod = (AggDatasetOuter)map.get(id);
            if (null == dod) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(" have cache but no dataset= {}", (Object)id);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" use cache for dataset= {}", (Object)id);
            }
            if ((mfile = dod.getMFile()) != null && mfile.getLastModified() > lastWritten) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(" dataset was changed= {}", (Object)mfile);
                continue;
            }
            if (dod.ncoord == 0) {
                String ncoordsS = netcdfElemNested.getAttributeValue("ncoords");
                try {
                    dod.ncoord = Integer.parseInt(ncoordsS);
                    if (logger.isDebugEnabled()) {
                        logger.debug(" Read the cache; ncoords = {}", (Object)dod.ncoord);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("bad ncoord attribute on dataset=" + id);
                }
            }
            List cacheElemList = netcdfElemNested.getChildren("cache", Catalog.ncmlNS);
            for (Element cacheElemNested : cacheElemList) {
                String varName = cacheElemNested.getAttributeValue("varName");
                AggregationOuter.CacheVar pv = this.findCacheVariable(varName);
                if (pv != null) {
                    String sdata = cacheElemNested.getText();
                    if (sdata.isEmpty()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug(" read data for var = " + varName + " size= " + sdata.length());
                    }
                    String[] vals = sdata.split(" ");
                    try {
                        Array data = Array.makeArray(pv.dtype, vals);
                        pv.putData(id, data);
                        ++countCacheUse;
                    }
                    catch (Exception e) {
                        logger.warn("Error reading cached data ", (Throwable)e);
                    }
                    continue;
                }
                logger.warn("not a cache var=" + varName);
            }
        }
    }

    private String getCacheName() {
        String cacheName = this.ncDataset.location;
        return cacheName;
    }
}

