/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.layout;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geo.layout.ElementType;
import org.meteoinfo.geo.layout.LayoutElement;
import org.meteoinfo.geometry.graphic.ResizeAbility;

public class LayoutChart
extends LayoutElement {
    private Chart chart;

    public LayoutChart() {
        this.setElementType(ElementType.LAYOUT_CHART);
        this.setResizeAbility(ResizeAbility.RESIZE_ALL);
        this.setWidth(200);
        this.setHeight(150);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart value) {
        this.chart = value;
    }

    @Override
    public void paint(Graphics2D g) {
    }

    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        if (this.chart == null) {
            return;
        }
        PointF aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
        Rectangle2D.Double area = new Rectangle2D.Double(aP.X, aP.Y, (float)this.getWidth() * zoom, (float)this.getHeight() * zoom);
        this.chart.draw(g, (Rectangle2D)area);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }
}

