/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import javax.annotation.Nullable;
import ucar.nc2.grib.coord.TimeCoordIntvDateValue;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class NwsMetDevTables
extends NcepLocalTables {
    NwsMetDevTables(Grib2TableConfig grib2Table) {
        super(grib2Table);
    }

    @Override
    @Nullable
    public TimeCoordIntvDateValue getForecastTimeInterval(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        boolean needOverride = false;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            needOverride = ti.timeRangeUnit == 255;
        }
        if (!needOverride) {
            return super.getForecastTimeInterval(gr);
        }
        CalendarDate intvEnd = pdsIntv.getIntervalTimeEnd();
        int ftime = pdsIntv.getForecastTime();
        int timeUnitOrg = pds.getTimeUnit();
        int timeUnitConvert = this.convertTimeUnit(timeUnitOrg);
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(timeUnitConvert);
        if (unitPeriod == null) {
            throw new IllegalArgumentException("unknown CalendarPeriod " + timeUnitConvert + " org=" + timeUnitOrg);
        }
        CalendarPeriod.Field fld = unitPeriod.getField();
        CalendarDate referenceDate = gr.getReferenceDate();
        CalendarDate intvStart = referenceDate.add((double)ftime, fld);
        return new TimeCoordIntvDateValue(intvStart, intvEnd);
    }

    @Override
    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        boolean needOverride = false;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            needOverride = ti.timeRangeUnit == 255;
        }
        if (!needOverride) {
            return super.getForecastTimeIntervalSizeInHours(pds);
        }
        return 12.0;
    }
}

