X = linspace(-pi, pi, 256, endpoint=True)
C = cos(X)
S = sin(X)
t = 2 * pi / 3

axes(outerposition=[0,0,1,1])
lcosine = plot(X, C, color='blue', linewidth=2.5, linestyle='-', label='cosine')
plot([t,t],[0,cos(t)], color='blue', linewidth=2.5, linestyle="--")
scatter([t,],[cos(t),], s=6, color ='blue', edgecolor=None)
annotate(r'$\rm cos(\frac{2\pi}{3})=-\frac{1}{2}$',
         (t, cos(t)), (t*0.5, cos(t)-0.2), fontsize=18, xalign='center',
         yalign='top',
         arrowprops=dict(linewidth=1, headwidth=8, shrink=0.05, overhang=1))

lsine = plot(X, S, color='red', linewidth=2.5, linestyle='-', label='sine')
plot([t,t],[0,sin(t)], color='red', linewidth=2.5, linestyle="--")
scatter([t,],[sin(t),], s=6, c='red', edgecolor=None)
annotate(r'$\rm sin(\frac{2\pi}{3})=\frac{\sqrt{3}}{2}$',
         (t, sin(t)), (t+0.1, sin(t)+0.2), fontsize=18, xalign='left',
         arrowprops=dict(linewidth=1, headwidth=8, shrink=0.05, overhang=1))

xaxis(location='top', visible=False)
xaxis(location='bottom', position=('data',0))
yaxis(location='right', visible=False)
yaxis(location='left', position=('data',0))

xlim(X.min() * 1.3, X.max() * 1.3)
xticks([-pi, -pi/2, 0, pi/2, pi],
  [r'$-\pi$', r'$-\pi/2$', r'$0$', r'$+\pi/2$', r'$+\pi$'])

ylim(C.min() * 1.3, C.max() * 1.3)
yticks([-1, 0, +1], [r'$-1$', r'$0$', r'$+1$'])

legend([lcosine, lsine], loc='upper left')