/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.authentication;

import gov.nasa.giss.ui.ClickableLinkMouseListener;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.apache.http.auth.AuthScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBasicAuthenticationDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JTextField nameTF_;
    private JPasswordField passwdTF_;
    private JButton cancelBtn_;
    private JButton loginBtn_;
    private boolean success_;

    public PanBasicAuthenticationDialog(JFrame parent, AuthScope scope) {
        super(parent, "Authenticate", true);
        this.createLayout(scope);
        this.attachListeners();
    }

    private void createLayout(AuthScope scope) {
        QuickBox buttonBox;
        MultiLineLabel messageLabel = new MultiLineLabel("To access the dataset, you must log in to this area on " + scope.getHost() + ":" + scope.getPort() + ":", 60, 2);
        String realmText = scope.getRealm();
        MultiLineLabel realmLabel = null;
        if (realmText != null && !realmText.isEmpty()) {
            String realmURL = this.findURL(realmText);
            realmLabel = new MultiLineLabel(realmText, 66, 2);
            if (realmURL != null) {
                realmLabel.addMouseListener(new ClickableLinkMouseListener(realmURL));
            }
        }
        JLabel warningLabel = scope.getPort() == 443 ? new JLabel("Your login credentials will be sent encrypted.") : new JLabel("Note that your password will be sent unencrypted.");
        JLabel nameLabel = new JLabel("Name:\u2009");
        JLabel passwdLabel = new JLabel("Password:\u2009");
        Font lFont = UIManager.getDefaults().getFont("Label.font");
        messageLabel.setFont(lFont.deriveFont((float)lFont.getSize() + 2.0f));
        if (realmLabel != null) {
            realmLabel.setFont(lFont);
        }
        warningLabel.setFont(lFont);
        this.nameTF_ = new JTextField("", 20);
        this.passwdTF_ = new JPasswordField("", 20);
        this.nameTF_.setMinimumSize(this.nameTF_.getPreferredSize());
        this.passwdTF_.setMinimumSize(this.passwdTF_.getPreferredSize());
        this.cancelBtn_ = new JButton("Cancel");
        this.loginBtn_ = new JButton("Load");
        QuickBox quickBox = buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.loginBtn_) : QuickBox.createRightBox(this.loginBtn_, this.cancelBtn_);
        if (realmLabel != null) {
            GuiUtils.padBorder(realmLabel, 0, 0, 6, 0);
        }
        GuiUtils.padBorder(warningLabel, 0, 0, 6, 0);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(4, 7, 0, 5);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        contentPanel.setLayout(fgl);
        GuiUtils.padBorder(contentPanel, 12, 12, 12, 12);
        contentPanel.add((Component)messageLabel, new FGConstraint(0, 0, 4, 1));
        if (realmLabel != null) {
            contentPanel.add((Component)realmLabel, new FGConstraint(0, 1, 4, 1));
        }
        contentPanel.add((Component)warningLabel, new FGConstraint(0, 2, 4, 1));
        contentPanel.add((Component)new JSeparator(), new FGConstraint(0, 3, 4, 1, 0.5, 0.5));
        contentPanel.add((Component)nameLabel, new FGConstraint(1, 4));
        contentPanel.add((Component)this.nameTF_, new FGConstraint(2, 4));
        contentPanel.add((Component)passwdLabel, new FGConstraint(1, 5));
        contentPanel.add((Component)this.passwdTF_, new FGConstraint(2, 5));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 6, 4, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.loginBtn_);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void attachListeners() {
        this.loginBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Rectangle rr = GuiUtils.getActiveScreenBounds();
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = rr.x + (rr.width - psize.width) / 2;
            int y = rr.y + (rr.height - psize.height) / 2;
            this.setLocation(x, y);
        }
        super.setVisible(visible);
        if (visible) {
            this.nameTF_.grabFocus();
        }
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public String getUserid() {
        return this.nameTF_.getText();
    }

    public String getPassword() {
        return new String(this.passwdTF_.getPassword());
    }

    private String findURL(String instr) {
        String urlRegex = "((https?|ftp):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)";
        Pattern pattern = Pattern.compile("((https?|ftp):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)", 2);
        Matcher urlMatcher = pattern.matcher(instr);
        if (urlMatcher.find()) {
            return instr.substring(urlMatcher.start(0), urlMatcher.end(0));
        }
        return null;
    }
}

