/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.overlay.PanOverlayFrame;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTablePanel;
import gov.nasa.giss.panoply.prefsui.PanOverlayTableModel;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableScrollPane;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;

public class PanOverlayLibPrefsPanel
extends PanCommonPrefsTablePanel
implements DropTargetListener {
    private static final String P_ALWAYS_IMPORT_OVERLAYS = "files:autoimport.overlays";
    private boolean refreshing_;

    @Override
    void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Overlays Library"));
        this.setOpaque(false);
        MultiLineLabel tText = new MultiLineLabel("Overlays selected as favorites will be listed at the top of\noverlay drop-down menus in map plot controls.", 0);
        this.checkMinBtn_ = PanButton.small("Check Minimal");
        this.checkAllBtn_ = PanButton.small("Check All");
        QuickBox buttonBox = QuickBox.createCenterBox(this.checkMinBtn_, this.checkAllBtn_);
        this.tmodel_ = new PanOverlayTableModel();
        this.table_ = new PanCommonPrefsTable(this.tmodel_);
        this.tspane_ = new PanPrefsTableScrollPane(this.table_);
        Border ob = this.tspane_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_UNFOCUSED_BORDER, ob);
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.tspane_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setMinusEnabled(false);
        JLabel bText = new JLabel("Built-in overlays cannot be removed.");
        GuiUtils.setSizeSmall(bText);
        this.autoimportCB_ = PanCheckBox.create("Always import new overlays into support library", false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        fgl.setColumnWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)tText, new FGConstraint(0, 0, 2, 1, true));
        this.add((Component)buttonBox, new FGConstraint(0, 1, 2, 1, true));
        this.add((Component)this.tspane_, new FGConstraint(0, 2, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 3));
        this.add((Component)bText, new FGConstraint(1, 3, 1.0));
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 4, 2, 1, 0.5, 0.5));
    }

    @Override
    void displaySelection(int index) {
        Object o = this.table_.getValueAt(index, 1);
        if (o instanceof String) {
            o = PanResourceUtils.getOverlay(index);
        }
        if (o instanceof MapOverlay) {
            MapOverlay oo = (MapOverlay)o;
            PanOverlayFrame.getSharedInstance().reveal();
            PanOverlayFrame.getSharedInstance().setOverlay(oo);
        }
    }

    @Override
    void additionRequested() {
        PanFrame pf = (PanFrame)this.getTopLevelAncestor();
        File[] ff = PanFileUtils.showOpenOverlayFileChooser(pf);
        if (ff != null) {
            PanResourceUtils.getOverlayList().addAlphabetic((Component)pf, ff);
        }
    }

    @Override
    void deletionRequested(int index) {
        this.table_.clearSelection();
        OverlayResourceList list = PanResourceUtils.getOverlayList();
        list.remove(index);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
        this.table_.repaint();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.autoimportCB_.setSelected(prefs_.getBoolean(P_ALWAYS_IMPORT_OVERLAYS));
        this.pmwidget_.setPlusEnabled(true);
        int row = this.table_.getSelectedRow();
        OverlayResourceList oset = PanResourceUtils.getOverlayList();
        if (row < 0 || row >= oset.getSize()) {
            this.pmwidget_.setMinusEnabled(false);
        } else {
            this.pmwidget_.setMinusEnabled(oset.canRemove(row));
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!OverlayFilenameFilter.isOverlayName(f)) continue;
                    addlist.add(f);
                }
                PanResourceUtils.getOverlayList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.tspane_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.tspane_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

