/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatUgrid;
import gov.nasa.giss.data.nc.array.NcArrayLonLatUgridUtils;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatUgrid;
import gov.nasa.giss.math.GeometryUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatUgridFaces
extends NcArray
implements NcArrayLonLat,
NcArrayLonLatUgrid,
NcArrayLonLatUgridUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double RAD_PER_DEG = Math.PI / 180;
    private int numFaces_ = -1;
    private int faceDimIndex_ = -1;
    private VariableDS faceLonVarDS_;
    private VariableDS faceLatVarDS_;
    private double[] faceLons_;
    private double[] faceLats_;
    private Array nodeLonArray_;
    private Array nodeLatArray_;
    private Index nodeLonIndex_;
    private Index nodeLatIndex_;

    public NcArrayLonLatUgridFaces(NcVariable ncvar) throws NcException {
        super(ncvar);
        if (!NcArrayLonLatUgridUtils.hasUgridAttributes(this.dataset_, this.njvarDS_, "face")) {
            throw new NcException("Variable does not have valid UGRID attributes");
        }
        this.createCoordinates();
        this.initGridArrays();
        this.initGridBounds();
        this.faceLonVarDS_ = null;
        this.faceLatVarDS_ = null;
    }

    private void createCoordinates() {
        VariableDS[] cvars = NcArrayLonLatUgridUtils.getCoordinateVars(this.ncvar_);
        if (cvars == null) {
            throw new NcException("Coordinate vars not found.");
        }
        this.faceLonVarDS_ = cvars[0];
        this.faceLatVarDS_ = cvars[1];
        if (this.faceLonVarDS_.getRank() != 1 || this.faceLatVarDS_.getRank() != 1) {
            throw new NcException("Lon and lat coordinate variable(s) are not D");
        }
        LOGGER.trace("lon {}, lat {}", (Object)this.faceLonVarDS_.getShortName(), (Object)this.faceLatVarDS_.getShortName());
        Dimension facedim = this.faceLonVarDS_.getDimension(0);
        LOGGER.trace("facedim {}", (Object)facedim);
        this.faceDimIndex_ = this.findDimensionIndex(this.faceLonVarDS_);
        LOGGER.trace("faceDimIndex {}", (Object)this.faceDimIndex_);
        if (this.faceDimIndex_ < 0) {
            throw new NcException("Face dimension index is not set.");
        }
        this.numFaces_ = facedim.getLength();
        LOGGER.trace("numFaces, {}", (Object)this.numFaces_);
    }

    private void initGridArrays() {
        Array latArray;
        Array lonArray;
        try {
            lonArray = this.faceLonVarDS_.read();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read longitude coordinates array: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Could not read longitude coordinates array.", exc);
        }
        try {
            latArray = this.faceLatVarDS_.read();
        }
        catch (Exception exc) {
            LOGGER.debug("Could not read latitude coordinates array: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Could not read latitude coordinates array.", exc);
        }
        this.faceLons_ = new double[this.numFaces_];
        this.faceLats_ = new double[this.numFaces_];
        for (int i = 0; i < this.numFaces_; ++i) {
            this.faceLons_[i] = lonArray.getDouble(i);
            this.faceLats_[i] = latArray.getDouble(i);
        }
    }

    private void initGridBounds() {
        VariableDS nodeLonVarDS = NcArrayLonLatUgridFaces.getBoundsFor(this.dataset_, this.faceLonVarDS_);
        VariableDS nodeLatVarDS = NcArrayLonLatUgridFaces.getBoundsFor(this.dataset_, this.faceLatVarDS_);
        if (nodeLonVarDS == null || nodeLatVarDS == null) {
            throw new NcException("Coordinate bounds variables were not found.");
        }
        Dimension dd2 = nodeLonVarDS.getDimension(1);
        int faceCorners = dd2.getLength();
        LOGGER.trace("faceCorners {}", (Object)faceCorners);
        if (faceCorners != 3) {
            throw new NcException("Mesh faces must have exactly three corners.");
        }
        try {
            this.nodeLonArray_ = nodeLonVarDS.read();
            this.nodeLonIndex_ = this.nodeLonArray_.getIndex();
            LOGGER.trace("nodeLonArray is type {}", (Object)this.nodeLonArray_.getElementType());
            LOGGER.trace("nodeLonArray is class {}", (Object)this.nodeLonArray_.getClass());
        }
        catch (Exception exc) {
            throw new NcException("Could not read longitude coordinates bounds");
        }
        try {
            this.nodeLatArray_ = nodeLatVarDS.read();
            this.nodeLatIndex_ = this.nodeLatArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read latitude coordinates bounds");
        }
    }

    @Override
    public int getLength() {
        return this.numFaces_;
    }

    @Override
    public double longitudeAt(int index) {
        return this.faceLons_[index];
    }

    @Override
    public double latitudeAt(int index) {
        return this.faceLats_[index];
    }

    @Override
    public double valueAt(int index) {
        if (index < 0 || index >= this.numFaces_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + ", " + this.numFaces_);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed -  index = {}.{}", (Object)index);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    @Override
    public double[][] cornerLonLats(int index) {
        double lat0;
        double lon0 = this.longitudeAt(index);
        if (NcArrayLonLat.isBadLonLat(lon0, lat0 = this.latitudeAt(index))) {
            return null;
        }
        if (lon0 > 180.0) {
            lon0 -= 360.0;
        }
        if (lon0 < -180.0) {
            lon0 += 360.0;
        }
        double lon1 = this.nodeLonArray_.getDouble(this.nodeLonIndex_.set(index, 0));
        double lon2 = this.nodeLonArray_.getDouble(this.nodeLonIndex_.set(index, 1));
        double lon3 = this.nodeLonArray_.getDouble(this.nodeLonIndex_.set(index, 2));
        if (lon0 - lon1 > 45.0) {
            lon1 += 360.0;
        }
        if (lon0 - lon2 > 45.0) {
            lon2 += 360.0;
        }
        if (lon0 - lon3 > 45.0) {
            lon3 += 360.0;
        }
        if (lon1 - lon0 > 45.0) {
            lon1 -= 360.0;
        }
        if (lon2 - lon0 > 45.0) {
            lon2 -= 360.0;
        }
        if (lon3 - lon0 > 45.0) {
            lon3 -= 360.0;
        }
        double lat1 = this.nodeLatArray_.getDouble(this.nodeLatIndex_.set(index, 0));
        double lat2 = this.nodeLatArray_.getDouble(this.nodeLatIndex_.set(index, 1));
        double lat3 = this.nodeLatArray_.getDouble(this.nodeLatIndex_.set(index, 2));
        if (Double.isNaN(lat1)) {
            lat1 = lat0;
        }
        if (Double.isNaN(lat2)) {
            lat2 = lat0;
        }
        if (Double.isNaN(lat3)) {
            lat3 = lat0;
        }
        return new double[][]{{lon1, lat1}, {lon2, lat2}, {lon3, lat3}};
    }

    @Override
    protected void createFreeDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.faceDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    @Override
    protected void findExtremaImpl() {
        double[] range = this.getActualRangeAttrValues();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        for (int i = 0; i < this.numFaces_; ++i) {
            this.findExtremaTestValue(this.valueAt(i));
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatUgrid();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Face index cannot be null.");
        int face = index[0];
        if (face < 0 || face >= this.numFaces_) {
            sb.append("Face index outside valid range.");
            return;
        }
        double lon = this.faceLons_[face];
        double lat = this.faceLats_[face];
        double gv = this.valueAt(face);
        sb.append("Face [").append(face + 1).append(']').append(" at [").append(NcUtils.formatLongitude(lon)).append(' ').append(NcUtils.formatLatitude(lat)).append("], value = ").append(valFormat.sprintfx(gv));
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int index = -1;
        for (int i = 0; i < this.numFaces_; ++i) {
            double lat1;
            double lon1;
            try {
                lon1 = this.longitudeAt(i);
                lat1 = this.latitudeAt(i);
            }
            catch (Exception exc) {
                continue;
            }
            if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
            double dlon = lon1 - lon;
            double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
            double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
            double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
            double angle = Math.acos(cosAngle);
            if (angle == 0.0) {
                return new int[]{i};
            }
            if (!(angle < mindist)) continue;
            mindist = angle;
            index = i;
        }
        if (index < 0) {
            return null;
        }
        double[][] corners = this.cornerLonLats(index);
        if (corners == null) {
            return null;
        }
        if (GeometryUtils.isPointInTriangle(lon, lat, corners[0][0], corners[0][1], corners[1][0], corners[1][1], corners[2][0], corners[2][1])) {
            return new int[]{index};
        }
        return null;
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.faceDimIndex_] = index;
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.faceDimIndex_] = 0;
            sShape[this.faceDimIndex_] = this.numFaces_;
            this.slice_ = this.njvarDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatUgridFaces.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        LOGGER.trace("");
        if (!NcArrayLonLatUgridUtils.hasUgridAttributes(ncd, varDS, "face")) {
            return false;
        }
        VariableDS[] gridvars = NcArrayLonLatUgridUtils.getCoordinateVars(ncd, varDS);
        boolean hasGridvars = gridvars != null;
        LOGGER.trace("hasGridvars {}", (Object)hasGridvars);
        if (!hasGridvars) {
            return false;
        }
        return NcArrayLonLatUgridFaces.validateCoordinateVars(ncd, varDS, gridvars[0], gridvars[1]);
    }

    private static boolean validateCoordinateVars(NcDataset ncd, VariableDS varDS, VariableDS lonCV, VariableDS latCV) {
        Dimension dd2;
        if (lonCV == null) {
            LOGGER.trace("Longitude CV is null");
            return false;
        }
        if (latCV == null) {
            LOGGER.trace("Latitude CV is null");
            return false;
        }
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(varDS);
        String lonName = lonCV.getShortName();
        String latName = latCV.getShortName();
        LOGGER.trace("Lon-Lat CVS {}, {}", (Object)lonName, (Object)latName);
        if (!lonName.startsWith(meshStr)) {
            LOGGER.trace("Longitude CV name does not start with '{}'", (Object)meshStr);
            return false;
        }
        if (!latName.startsWith(meshStr)) {
            LOGGER.trace("Latitude CV name does not start with '{}'", (Object)meshStr);
            return false;
        }
        if (!lonName.endsWith("_face_x")) {
            LOGGER.trace("Longitude CV name does not end in 'face_x'");
            return false;
        }
        if (!latName.endsWith("_face_y")) {
            LOGGER.trace("Latitude CV name does not end in 'face_y'");
            return false;
        }
        int varRank = varDS.getRank();
        int lonRank = lonCV.getRank();
        int latRank = latCV.getRank();
        LOGGER.trace("ranks: var {}, lon {}, lat {}", varRank, lonRank, latRank);
        if (lonRank != 1) {
            LOGGER.trace("Longitude CV must be rank 1.");
            return false;
        }
        if (latRank != 1) {
            LOGGER.trace("Latitude CV must be rank 1.");
            return false;
        }
        Dimension dd1 = lonCV.getDimension(0);
        if (!dd1.equals(dd2 = latCV.getDimension(0))) {
            return false;
        }
        int didx = NcUtils.findDimensionIndex(varDS, dd1);
        if (didx < 0) {
            return false;
        }
        LOGGER.trace("== check for bounds vars");
        VariableDS nodeLonVar = NcArrayLonLatUgridFaces.getBoundsFor(ncd, lonCV);
        VariableDS nodeLatVar = NcArrayLonLatUgridFaces.getBoundsFor(ncd, latCV);
        return nodeLonVar != null && nodeLatVar != null;
    }

    private static VariableDS getBoundsFor(NcDataset ncd, VariableDS coordVarDS) {
        LOGGER.trace("== looking for bounds attr on CV {}", (Object)coordVarDS.getShortName());
        String boundsStr = NcUtils.getAttributeStringIgnoreCase(coordVarDS, "bounds");
        LOGGER.trace("== bounds attribute, {}", (Object)boundsStr);
        if (boundsStr == null) {
            return null;
        }
        VariableDS boundsVar = ncd.getVariableDS(boundsStr);
        if (boundsVar == null) {
            LOGGER.trace("== bounds var not found");
            return null;
        }
        if (boundsVar.getRank() != 2) {
            LOGGER.trace("== bounds var does not have rank 2");
            return null;
        }
        int[] vShape = coordVarDS.getShape();
        int[] bShape = boundsVar.getShape();
        if (bShape[0] != vShape[0]) {
            LOGGER.trace("== bounds var has different length than coordinate var?");
            return null;
        }
        LOGGER.trace("== bounds var has {} corners", (Object)bShape[1]);
        return boundsVar;
    }
}

