/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmericanPolyconic
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "American Polyconic";
    public static final int PROPERTIES = 0x200020;
    private static final double LOBE_LAT = 40.9091798673;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.407633359663;
    private static final double DEFAULT_HEIGHT = 45.0;
    private double height_ = 45.0;
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Height", "\u00b0", 45.0, 0.002, 180.0, true, true);

    public AmericanPolyconic(int width, int height) {
        this(width, height, 0, 0);
    }

    public AmericanPolyconic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200020, width, height, xmargin, ymargin, Math.PI, 2.407633359663);
        this.addParameter(this.hgtParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.hgtParam_)) {
            this.setHeight(this.hgtParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setHeight(double height) {
        this.height_ = height;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double halfHRad = 0.5 * Math.toRadians(this.height_);
        Insets ins = this.getInsets();
        double uw = (double)this.getWidth() - 2.0 * (double)ins.left;
        double uh = (double)this.getHeight() - 2.0 * (double)ins.top;
        double www = Math.min(Math.PI, halfHRad * uw / uh);
        this.setMaxXYOverRS(www, halfHRad);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(lambdaRad) < 1.0E-5) {
            y = phiRad - this.phiCRad_;
        } else if (Math.abs(phiRad) < 1.0E-5) {
            x = lambdaRad;
            y = -this.phiCRad_;
        } else {
            double sinPhi = Math.sin(phiRad);
            double cotPhi = Math.tan(phiRad) / sinPhi;
            double thetaRad = lambdaRad * sinPhi;
            x = cotPhi * Math.sin(thetaRad);
            y = phiRad - this.phiCRad_ + cotPhi * (1.0 - Math.cos(thetaRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lat;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        double yP = y + this.phiCRad_ * this.rS_;
        double absYP = Math.abs(yP);
        double xOverRS = absX * this.invRS_;
        double yPOverRS = absYP * this.invRS_;
        if (yP == 0.0) {
            if (Math.abs(xOverRS) > Math.PI) {
                return null;
            }
            return new PointLL(this.lambdaC_ + xOverRS, 0.0);
        }
        if (x == 0.0) {
            if (Math.abs(yPOverRS) > 1.5707963267948966) {
                return null;
            }
            return new PointLL(this.lambdaC_, yPOverRS);
        }
        double phiRad0 = absYP < 1.5707963267948966 * this.rS_ ? yPOverRS : 1.5707963267948966 - Math.toRadians(40.9091798673 * (yPOverRS - 1.5707963267948966) / 0.8368370328681034);
        double[] llRad = this.iterateXY2LLRad(absX, absYP, phiRad0);
        if (llRad == null || Double.isNaN(llRad[0]) || Double.isNaN(llRad[1])) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(llRad[0]);
        double lon = this.lambdaC_ + lambda;
        Point2D.Double xy = this.transformLL2XY(lon, lat = (phi = Math.signum(yP) * Math.toDegrees(llRad[1])));
        if (xy != null && Math.abs(xy.x - xx) < 5.0 && Math.abs(xy.y - yy) < 5.0) {
            return new PointLL(lon, lat);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AmericanPolyconic americanPolyconic = this;
        synchronized (americanPolyconic) {
            double yyy = 1.5707963267948966 * this.rS_;
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yP = y + this.phiCRad_ * this.rS_;
                double absYP = Math.abs(yP);
                double yPOverRS = absYP * this.invRS_;
                double phiRad = absYP < yyy ? yPOverRS : 1.5707963267948966 - Math.toRadians(40.9091798673 * (yPOverRS - 1.5707963267948966) / 0.8368370328681034);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] llRad = this.iterateXY2LLRad(x, absYP, phiRad);
                    if (llRad == null) continue;
                    double lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    if (yP < 0.0) {
                        phiRad = -phiRad;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] iterateXY2LLRad(double x, double y, double phiRad0) {
        double sinPhi;
        double tanPhi;
        double yOverRS = y * this.invRS_;
        double xOverRS = x * this.invRS_;
        double yy = yOverRS;
        double rho2 = xOverRS * xOverRS + yOverRS * yOverRS;
        double twoYY = 2.0 * yy;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double twoPhiRad = 2.0 * phiRad;
            double phiRad2 = phiRad * phiRad;
            tanPhi = Math.tan(phiRad);
            double phiTanPhi = phiRad * tanPhi;
            double sec2Phi = 1.0 + tanPhi * tanPhi;
            double func = twoYY * (phiTanPhi + 1.0) - twoPhiRad - (phiRad2 + rho2) * tanPhi;
            double dfunc = twoYY * (tanPhi + phiRad * sec2Phi) - 2.0 - twoPhiRad * tanPhi - (phiRad2 + rho2) * sec2Phi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (x == 0.0) {
            return new double[]{0.0, phiRad};
        }
        tanPhi = Math.tan(phiRad);
        double cosTheta = 1.0 - (yOverRS - phiRad) * tanPhi;
        double thetaRad = Math.acos(cosTheta);
        double lambdaRad = thetaRad / (sinPhi = Math.sin(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double rrx;
        double llx;
        boolean equ;
        Insets ins = this.getInsets();
        Path2D.Double path = new Path2D.Double();
        int ww = this.getWidth();
        int hh = this.getHeight();
        double ll = ins.left;
        double tt = ins.top;
        double rr = ww - ins.right;
        double bb = hh - ins.bottom;
        boolean npole = this.transformLL2XY(this.lambdaC_, 90.0) != null;
        boolean spole = this.transformLL2XY(this.lambdaC_, -90.0) != null;
        boolean nlobe = this.transformLL2XY(this.lambdaC_ + 179.99999, 40.9091798673) != null;
        boolean slobe = this.transformLL2XY(this.lambdaC_ + 179.99999, -40.9091798673) != null;
        boolean tr = this.transformXY2LL(rr, tt) == null;
        boolean br = this.transformXY2LL(rr, bb) == null;
        boolean bl = equ = this.transformLL2XY(this.lambdaC_ + 179.99999, 0.0) != null;
        if (!nlobe) {
            if (npole || tr) {
                llx = npole ? this.findBorderX(tt, 60.0) : Double.NaN;
                double d = rrx = tr ? this.findBorderX(tt, 20.0) : Double.NaN;
                if (!Double.isNaN(llx) && !Double.isNaN(rrx)) {
                    path.reset();
                    path.moveTo((double)ww - rrx, tt);
                    path.lineTo((double)ww - llx, tt);
                    path.moveTo(llx, tt);
                    path.lineTo(rrx, tt);
                } else if (Double.isNaN(rrx)) {
                    path.reset();
                    path.moveTo(ll, tt);
                    path.lineTo((double)ww - llx, tt);
                    path.moveTo(llx, tt);
                    path.lineTo(rr, tt);
                } else if (Double.isNaN(llx)) {
                    path.reset();
                    path.moveTo((double)ww - rrx, tt);
                    path.lineTo(rrx, tt);
                }
            } else {
                path.reset();
                path.moveTo(ll, tt);
                path.lineTo(rr, tt);
            }
        }
        g2d.draw(path);
        if (!equ) {
            if (!tr && !br) {
                path.reset();
                path.moveTo(rr, tt);
                path.lineTo(rr, bb);
                path.moveTo(ll, bb);
                path.lineTo(ll, tt);
                g2d.draw(path);
            } else {
                double bby;
                double tty = tr ? this.findBorderY(rr, 20.0) : Double.NaN;
                double d = bby = br ? this.findBorderY(rr, -20.0) : Double.NaN;
                if (!Double.isNaN(tty) && !Double.isNaN(bby)) {
                    path.reset();
                    path.moveTo(rr, tty);
                    path.lineTo(rr, bby);
                    path.moveTo(ll, tty);
                    path.lineTo(ll, bby);
                } else if (Double.isNaN(tty)) {
                    path.reset();
                    path.moveTo(rr, tt);
                    path.lineTo(rr, bby);
                    path.moveTo(ll, tt);
                    path.lineTo(ll, bby);
                } else {
                    path.reset();
                    path.moveTo(rr, tty);
                    path.lineTo(rr, bb);
                    path.moveTo(ll, tty);
                    path.lineTo(ll, bb);
                }
                g2d.draw(path);
            }
        }
        if (!slobe) {
            if (!spole && !br) {
                path.reset();
                path.moveTo(ll, bb);
                path.lineTo(rr, bb);
                g2d.draw(path);
            } else {
                llx = spole ? this.findBorderX(bb, -60.0) : Double.NaN;
                double d = rrx = br ? this.findBorderX(bb, -20.0) : Double.NaN;
                if (!Double.isNaN(llx) && !Double.isNaN(rrx)) {
                    path.reset();
                    path.moveTo((double)ww - rrx, bb);
                    path.lineTo((double)ww - llx, bb);
                    path.moveTo(llx, bb);
                    path.lineTo(rrx, bb);
                } else if (Double.isNaN(rrx)) {
                    path.reset();
                    path.moveTo(ll, bb);
                    path.lineTo((double)ww - llx, bb);
                    path.moveTo(llx, bb);
                    path.lineTo(rr, bb);
                } else if (Double.isNaN(llx)) {
                    path.reset();
                    path.moveTo((double)ww - rrx, bb);
                    path.lineTo(rrx, bb);
                }
                g2d.draw(path);
            }
        }
        if (npole || spole || tr || br) {
            Graphics2D g2x = (Graphics2D)g2d.create();
            g2x.setStroke(ProjGraphicUtils.getButtRoundStroke(g2d.getStroke()));
            super.drawMeridian(g2d, this.lambdaC_ + 179.99999, 90.0, null);
            super.drawMeridian(g2d, this.lambdaC_ - 179.99999, 90.0, null);
            g2x.dispose();
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }

    private double findBorderX(double yy, double phi0) {
        double thetaRad;
        double cotPhi;
        double tanPhi;
        double sinPhi;
        double y = (double)this.outCenterY_ - yy;
        double yP = y + this.phiCRad_ * this.rS_;
        double yPOverRS = yP * this.invRS_;
        double phiRad = Math.toRadians(phi0);
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            tanPhi = Math.tan(phiRad);
            cotPhi = 1.0 / tanPhi;
            double cscPhi = 1.0 / sinPhi;
            thetaRad = Math.PI * sinPhi;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double func = phiRad + cotPhi * (1.0 - cosTheta) - yPOverRS;
            double dfunc = 1.0 - cscPhi * cscPhi * (1.0 - cosTheta) + cotPhi * sinTheta * Math.PI * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return Double.NaN;
        }
        sinPhi = Math.sin(phiRad);
        tanPhi = Math.tan(phiRad);
        cotPhi = 1.0 / tanPhi;
        thetaRad = Math.PI * sinPhi;
        double x = cotPhi * Math.sin(thetaRad);
        return (double)this.outCenterX_ + x * this.rS_;
    }

    private double findBorderY(double xx, double phi0) {
        double thetaRad;
        double cotPhi;
        double tanPhi;
        double sinPhi;
        double x = xx - (double)this.outCenterX_;
        double xOverRS = x * this.invRS_;
        double phiRad = Math.toRadians(phi0);
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            tanPhi = Math.tan(phiRad);
            cotPhi = 1.0 / tanPhi;
            double cscPhi = 1.0 / sinPhi;
            thetaRad = Math.PI * sinPhi;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double func = cotPhi * sinTheta - xOverRS;
            double dfunc = -cscPhi * cscPhi * sinTheta + cotPhi * cosTheta * Math.PI * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return Double.NaN;
        }
        sinPhi = Math.sin(phiRad);
        tanPhi = Math.tan(phiRad);
        cotPhi = 1.0 / tanPhi;
        thetaRad = Math.PI * sinPhi;
        double y = phiRad - this.phiCRad_ + cotPhi * (1.0 - Math.cos(thetaRad));
        return (double)this.outCenterY_ - y * this.rS_;
    }
}

