/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class PutninsP2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P2";
    private static final double CONST_A = 0.947449;
    private static final double CONST_B = 1.718482;
    private static final double CONST_C = 1.2283696986087567;
    private static final double INV_C = 0.8140871605125015;
    private static final double MAX_X_OVER_RS = 2.9764988180509957;
    private static final double MAX_Y_OVER_RS = 1.4882490679462896;
    private double invRSA_;
    private double invRSB_;

    public PutninsP2(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.9764988180509957, 1.4882490679462896);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invRSA_ = this.invRS_ / 0.947449;
        this.invRSB_ = this.invRS_ / 1.718482;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double cSinPhi = 1.2283696986087567 * Math.sin(phiRad);
        double psiRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoPsiRad = 2.0 * psiRad;
            double func = twoPsiRad + Math.sin(twoPsiRad) - 2.0 * Math.sin(psiRad) - cSinPhi;
            double dfunc = 2.0 * (1.0 + Math.cos(twoPsiRad) - Math.cos(psiRad));
            double dpsiRad = -func / dfunc;
            psiRad += dpsiRad;
            if (Math.abs(dpsiRad) < 1.0E-5) break;
        }
        double x = 0.947449 * this.lonToLambdaRad(lon) * (2.0 * Math.cos(psiRad) - 1.0);
        double y = 1.718482 * Math.sin(psiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = Math.asin(y * this.invRSB_);
        double sinPhi = (2.0 * psiRad + Math.sin(2.0 * psiRad) - 2.0 * Math.sin(psiRad)) * 0.8140871605125015;
        double phiRad = Math.asin(sinPhi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRSA_ / (2.0 * Math.cos(psiRad) - 1.0);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PutninsP2 putninsP2 = this;
        synchronized (putninsP2) {
            double y;
            double psiRad;
            double sinPhi;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(sinPhi = (2.0 * (psiRad = Math.asin((y = (double)iy + 0.5) * this.invRSB_)) + Math.sin(2.0 * psiRad) - 2.0 * Math.sin(psiRad)) * 0.8140871605125015)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRSA_ / (2.0 * Math.cos(psiRad) - 1.0);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (absLambdaRad < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            double rectW = 3.789796 * absLambdaRad * this.rS_;
            double rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            double rectH = 3.436964 * this.rS_;
            double rectY = (double)this.outCenterY_ - 1.718482 * this.rS_;
            if (lambdaRad > 0.0) {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotN);
            } else {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotS);
            }
        }
    }
}

