/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.ColorTableOutlierShape;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanColorbarTickLength;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHorizontalColorbar
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double COS45 = Math.cos(Math.toRadians(45.0));
    private final PanData data_;
    private AbstractColorTable clut_;
    private boolean clutReversed_;
    private float lengthFrac_ = 0.5f;
    private boolean useCustomCaption_;
    private String customCaption_ = "";
    private PanColorbarLabelLocation captionLoc_ = PanColorbarLabelLocation.ABOVE;
    private Font captionFont_;
    private float captionY_;
    private float barThickness_;
    private float barLength_;
    private float barTopY_;
    private float barBottomY_;
    private float barLeft_;
    private float barRight_;
    private Font ticksFont_;
    private float ticksY_;
    private PanColorbarOutlierSide oside_;
    private ColorTableOutlierShape oshape_;
    private PanColorbarOutlierGap ogap_ = PanColorbarOutlierGap.THIN;
    private boolean outlierOnLeft_;
    private boolean outlierOnRight_;
    private boolean outlierFlushLeft_;
    private boolean outlierFlushRight_;
    private float outlierGap_;
    private float outlierWidth_;
    private float minX_;
    private float maxX_;
    private float vectorLeft_;
    private float vectorLength_;
    private boolean vectorSampleVis_;
    private int vectorWeight_;
    private PanVectorStyle vectorStyle_;
    private BasicStroke vectorStroke_;
    private PanColorbarTickLength tickLength_ = PanColorbarTickLength.SHORT;
    private BasicStroke tickStroke_;
    private int borderWgt_;
    private BasicStroke borderStroke_;
    private boolean needsMeasurement_ = true;

    public PanHorizontalColorbar(PanPlotMeta pmeta) {
        super(pmeta);
        this.data_ = pmeta.getData();
        this.setOpaque(false);
        this.setClippingDisabled(true);
        this.parameterChangedPrivate("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsMeasurement_ = true;
    }

    @Override
    protected void prepareToPaint() {
        String caption;
        if (PanColorbarLocation.matching(this.pmeta_.getString("colorbar.location")).isVertical()) {
            LOGGER.trace("Colorbar place has changed; skipping paint.");
            return;
        }
        super.prepareToPaint();
        if (!this.needsMeasurement_) {
            return;
        }
        String fn = this.pmeta_.getString("labels.font");
        int width = this.getWidth();
        PlotPieceMargins margins = this.getMargins();
        float scaling = 0.01f * (float)this.pmeta_.getInt("size.factor");
        this.barThickness_ = scaling * 14.0f + 0.5f;
        float tickBaseSize = PanPlotConstraints.constrainScaleTickLabelSize(this.pmeta_.getFloat("scale.tick.size"));
        float captionBaseSize = PanPlotConstraints.constrainScaleLabelSize(this.pmeta_.getFloat("scale.label.size"));
        float captionFHeight = scaling * captionBaseSize + 0.5f;
        float ticksFHeight = scaling * tickBaseSize + 0.5f;
        int gap1 = Math.max(4, (int)(scaling * 5.0f + 0.5f));
        int gap2 = Math.max(2, (int)(scaling * 2.0f + 0.5f));
        this.captionFont_ = PanGraphicUtils.getFont(fn, captionFHeight);
        this.ticksFont_ = PanGraphicUtils.getFont(fn, ticksFHeight);
        String string = caption = this.useCustomCaption_ ? this.customCaption_ : this.data_.getDescription();
        if (caption == null || caption.isEmpty() || this.captionLoc_ == PanColorbarLabelLocation.NONE) {
            this.captionY_ = 0.0f;
            this.barTopY_ = margins.getTop() + 1;
            this.barBottomY_ = this.barTopY_ + this.barThickness_;
            this.ticksY_ = (int)(this.barBottomY_ + (float)gap2 + ticksFHeight);
        } else if (this.captionLoc_ == PanColorbarLabelLocation.ABOVE) {
            this.captionY_ = (int)((float)margins.getTop() + captionFHeight);
            this.barTopY_ = this.captionY_ + (float)gap1;
            this.barBottomY_ = this.barTopY_ + this.barThickness_;
            this.ticksY_ = (int)(this.barBottomY_ + (float)gap2 + ticksFHeight);
        } else if (this.captionLoc_ == PanColorbarLabelLocation.BELOW) {
            this.barTopY_ = margins.getTop() + 1;
            this.barBottomY_ = this.barTopY_ + this.barThickness_;
            this.ticksY_ = (int)(this.barBottomY_ + (float)gap2 + ticksFHeight);
            this.captionY_ = (int)(this.ticksY_ + (float)gap2 + captionFHeight);
        }
        if (this.ogap_ == null) {
            LOGGER.debug("ogap is null. How did that happen?");
            this.ogap_ = PanColorbarOutlierGap.NONE;
        }
        switch (this.ogap_) {
            case THIN: {
                this.outlierGap_ = 0.25f * this.barThickness_;
                break;
            }
            case WIDE: {
                this.outlierGap_ = 0.5f * this.barThickness_;
                break;
            }
            default: {
                this.outlierGap_ = 0.0f;
            }
        }
        if (this.oside_ == PanColorbarOutlierSide.NONE) {
            this.outlierWidth_ = 0.0f;
            this.outlierGap_ = 0.0f;
        } else {
            switch (this.oshape_) {
                case TRIANGLE: {
                    this.outlierWidth_ = this.barThickness_;
                    break;
                }
                case TRIANGLE_2: {
                    this.outlierWidth_ = 2.0f * this.barThickness_;
                    break;
                }
                case TRIANGLE_3: {
                    this.outlierWidth_ = 3.0f * this.barThickness_;
                    break;
                }
                case RECTANGLE: {
                    this.outlierWidth_ = 0.5f * this.barThickness_;
                    break;
                }
                default: {
                    this.outlierWidth_ = this.barThickness_;
                }
            }
        }
        Rectangle mfBounds = this.pmeta_.getLayout().getRect("bounds.figure");
        this.minX_ = 0.5f * (float)(width - mfBounds.width);
        this.maxX_ = this.minX_ + (float)mfBounds.width;
        this.barLength_ = this.lengthFrac_ * (float)mfBounds.width - 2.0f * (this.outlierGap_ + this.outlierWidth_) + 2.0f;
        this.barLeft_ = 0.5f * ((float)width - this.barLength_);
        this.barRight_ = this.barLeft_ + this.barLength_;
        if (this.vectorSampleVis_) {
            float vectorGap = this.barThickness_;
            this.vectorLeft_ = this.barRight_ + this.outlierGap_ + this.outlierWidth_ + vectorGap;
            this.vectorLength_ = this.pmeta_.getLayout().getInt("vector.length");
            if (this.vectorLeft_ + this.vectorLength_ > this.maxX_) {
                float excess = this.vectorLeft_ + this.vectorLength_ - this.maxX_;
                this.barLeft_ -= excess;
                this.vectorLeft_ -= excess;
                if (this.minX_ > this.barLeft_ - this.outlierGap_ - this.outlierWidth_) {
                    excess = this.minX_ - (this.barLeft_ - this.outlierGap_ - this.outlierWidth_);
                    this.barLength_ -= excess;
                    this.barLeft_ += excess;
                }
                this.barRight_ = this.barLeft_ + this.barLength_;
                this.vectorLeft_ = this.barRight_ + this.outlierGap_ + this.outlierWidth_ + vectorGap;
            }
        } else {
            this.vectorWeight_ = 0;
            this.vectorStyle_ = PanVectorStyle.NONE;
            this.vectorLength_ = 0.0f;
        }
        this.needsMeasurement_ = false;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        if (PanColorbarLocation.matching(this.pmeta_.getString("colorbar.location")).isVertical()) {
            LOGGER.trace("Colorbar place has changed; skipping paint.");
            return;
        }
        if (this.clut_ == null) {
            LOGGER.warn("Color table is null; skipping paint.");
            return;
        }
        this.drawCaption(gx);
        this.drawColorbar(gx);
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                this.drawLogTicks(gx);
                break;
            }
            default: {
                this.drawStandardTicks(gx);
            }
        }
        if (this.vectorSampleVis_) {
            this.drawSampleVector(gx);
        }
    }

    private void drawCaption(Graphics2D g2d) {
        String labelstr;
        if (this.captionLoc_ == PanColorbarLabelLocation.NONE) {
            return;
        }
        String string = labelstr = this.useCustomCaption_ ? this.customCaption_ : this.data_.getDescription();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.captionFont_);
        Object label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        label = GraphicUtils.trimStringToFit(label, g2d, this.getWidth());
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        GraphicUtils.drawString(g2d, label, 0.5f * (float)(this.getWidth() - labelWidth), this.captionY_);
    }

    private void drawColorbar(Graphics2D g2d) {
        if (this.clut_ == null) {
            return;
        }
        float xleft = this.barLeft_ - this.outlierGap_;
        float xright = this.barRight_ + this.outlierGap_;
        GeneralPath path = new GeneralPath();
        switch (this.oshape_) {
            case TRIANGLE: 
            case TRIANGLE_2: 
            case TRIANGLE_3: {
                if (this.outlierOnLeft_) {
                    path.reset();
                    path.moveTo(xleft, this.barTopY_);
                    path.lineTo(xleft - this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                    path.lineTo(xleft, this.barBottomY_);
                    path.closePath();
                    g2d.setColor(this.clut_.getMinOutlierColor(this.clutReversed_));
                    g2d.fill(path);
                }
                if (!this.outlierOnRight_) break;
                path.reset();
                path.moveTo(xright, this.barTopY_);
                path.lineTo(xright + this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                path.lineTo(xright, this.barBottomY_);
                path.closePath();
                g2d.setColor(this.clut_.getMaxOutlierColor(this.clutReversed_));
                g2d.fill(path);
                break;
            }
            case RECTANGLE: {
                if (this.outlierOnLeft_) {
                    g2d.setColor(this.clut_.getMinOutlierColor(this.clutReversed_));
                    GraphicUtils.fillRect(g2d, xleft - this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barThickness_);
                }
                if (!this.outlierOnRight_) break;
                g2d.setColor(this.clut_.getMaxOutlierColor(this.clutReversed_));
                GraphicUtils.fillRect(g2d, xright, this.barTopY_, this.outlierWidth_, this.barThickness_);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.oshape_);
            }
        }
        int colorCount = this.clut_.getColorCount();
        float binWidth = this.barLength_ / (float)colorCount;
        for (int i = 0; i < colorCount; ++i) {
            Color c2;
            float binOffset = binWidth * (float)i;
            float binLeft = this.barLeft_ + binOffset;
            Color c1 = this.clut_.getColorAt(i, this.clutReversed_);
            int iwidth = 1;
            for (int j = i + 1; j < colorCount && (c2 = this.clut_.getColorAt(j, this.clutReversed_)).equals(c1); ++j) {
                ++iwidth;
            }
            float colorWidth = binWidth * (float)iwidth;
            colorWidth += 0.75f;
            if ((i += iwidth - 1) == 0 && this.outlierOnLeft_ && this.outlierGap_ == 0.0f) {
                binLeft -= 0.1f;
                colorWidth += 0.1f;
            } else if (binLeft + colorWidth > this.barRight_) {
                colorWidth = this.barRight_ - binLeft + 0.1f;
                if (this.outlierOnRight_ && this.outlierGap_ == 0.0f) {
                    colorWidth += 0.1f;
                }
            }
            g2d.setColor(this.clut_.getColorAt(i, this.clutReversed_));
            GraphicUtils.fillRect(g2d, binLeft, this.barTopY_, colorWidth, this.barThickness_);
        }
        if (this.borderStroke_ == null) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        if (this.oside_ == PanColorbarOutlierSide.NONE) {
            GraphicUtils.drawRect(g2d, this.barLeft_, this.barTopY_, this.barLength_, this.barThickness_);
        } else if (this.ogap_ == PanColorbarOutlierGap.NONE) {
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    path.reset();
                    path.moveTo(this.barLeft_, this.barTopY_);
                    path.lineTo(this.barRight_, this.barTopY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barRight_ + this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                    }
                    path.lineTo(this.barRight_, this.barBottomY_);
                    path.lineTo(this.barLeft_, this.barBottomY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barLeft_ - this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    path.reset();
                    path.moveTo(this.barLeft_, this.barTopY_);
                    path.lineTo(this.barRight_, this.barTopY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barRight_ + this.outlierWidth_, this.barTopY_);
                        path.lineTo(this.barRight_ + this.outlierWidth_, this.barBottomY_);
                    }
                    path.lineTo(this.barRight_, this.barBottomY_);
                    path.lineTo(this.barLeft_, this.barBottomY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barLeft_ - this.outlierWidth_, this.barBottomY_);
                        path.lineTo(this.barLeft_ - this.outlierWidth_, this.barTopY_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
                default: {
                    LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.oshape_);
                    break;
                }
            }
        } else {
            GraphicUtils.drawRect(g2d, this.barLeft_, this.barTopY_, this.barLength_, this.barThickness_);
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    if (this.outlierOnLeft_) {
                        path.reset();
                        path.moveTo(xleft, this.barTopY_);
                        path.lineTo(xleft - this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                        path.lineTo(xleft, this.barBottomY_);
                        path.closePath();
                        g2d.setColor(this.getForeground());
                        g2d.draw(path);
                    }
                    if (!this.outlierOnRight_) break;
                    path.reset();
                    path.moveTo(xright, this.barTopY_);
                    path.lineTo(xright + this.outlierWidth_, this.barTopY_ + 0.5f * this.barThickness_);
                    path.lineTo(xright, this.barBottomY_);
                    path.closePath();
                    g2d.setColor(this.getForeground());
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    if (this.outlierOnLeft_) {
                        g2d.setColor(this.getForeground());
                        GraphicUtils.drawRect(g2d, xleft - this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barThickness_);
                    }
                    if (!this.outlierOnRight_) break;
                    g2d.setColor(this.getForeground());
                    GraphicUtils.drawRect(g2d, xright, this.barTopY_, this.outlierWidth_, this.barThickness_);
                    break;
                }
                default: {
                    LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.oshape_);
                }
            }
        }
    }

    private void drawStandardTicks(Graphics2D g2d) {
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PrintfFormat formatter = smeta.getFormatter();
        float tlength = this.tickLength_.getLength();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double scaleRange = Math.max(scaleMax - scaleMin, 1.0E-25);
        double mstep = (double)this.barLength_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.tickStroke_);
        g2d.setFont(this.ticksFont_);
        for (PanScaleTick tick : smeta.getTicks()) {
            String label;
            float tbottom;
            float ttop;
            double value = tick.getValue();
            float tickX = (float)((double)this.barLeft_ + (value - scaleMin) * mstep);
            boolean longTick = false;
            longTick = tick.isEndPoint() ? (this.borderStroke_ == null || this.borderWgt_ < 20 ? true : (value - scaleMin == 0.0 ? this.outlierFlushLeft_ : this.outlierFlushRight_)) : tick.isMajor();
            if (longTick) {
                ttop = this.barBottomY_ - tlength * this.barThickness_;
                tbottom = this.barBottomY_ + 0.2f * this.barThickness_;
            } else {
                ttop = this.barBottomY_ - 0.25f * this.barThickness_;
                tbottom = this.barBottomY_;
            }
            if (Math.abs(tickX - this.barLeft_) < 0.25f && !this.outlierFlushLeft_) {
                ttop = this.barBottomY_;
            } else if (Math.abs(tickX - this.barRight_) < 0.25f && !this.outlierFlushRight_) {
                ttop = this.barBottomY_;
            }
            if (ttop != tbottom) {
                GraphicUtils.drawLine(g2d, tickX, ttop, tickX, tbottom);
            }
            if (!tick.isMajor()) continue;
            String labelstr = formatter.sprintfx(value);
            String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
            if (label == null) continue;
            float labelWidth = GraphicUtils.stringWidth(label, g2d);
            float x = tickX - (float)((int)(0.5 * (double)labelWidth));
            if (x < this.minX_) {
                x = this.minX_;
            }
            if (x + labelWidth > this.maxX_) {
                x = this.maxX_ - labelWidth;
            }
            if (this.vectorSampleVis_ && x + labelWidth > this.barRight_ + this.outlierGap_ + this.outlierWidth_) {
                x = this.barRight_ + this.outlierGap_ + this.outlierWidth_ - labelWidth;
            }
            GraphicUtils.drawString(g2d, (Object)label, x, this.ticksY_);
        }
    }

    private void drawLogTicks(Graphics2D g2d) {
        double logScaleMax;
        double logScaleMin;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        PrintfFormat formatter = smeta.getFormatter();
        float tlength = this.tickLength_.getLength();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        switch (smethod) {
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                break;
            }
            default: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
            }
        }
        double scaleRange = Math.max(logScaleMax - logScaleMin, 1.0E-25);
        double mstep = (double)this.barLength_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.tickStroke_);
        g2d.setFont(this.ticksFont_);
        for (PanScaleTick tick : smeta.getTicks()) {
            float tbottom;
            float ttop;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            float tickX = (float)((double)this.barLeft_ + (logValue - logScaleMin) * mstep);
            switch (tick.getType()) {
                case MAJOR: {
                    Object label;
                    ttop = this.barBottomY_ - tlength * this.barThickness_;
                    tbottom = this.barBottomY_ + 0.2f * this.barThickness_;
                    switch (smethod) {
                        case LOG_E: {
                            label = PanStringUtils.getSuperscriptedE(logValue, g2d);
                            break;
                        }
                        default: {
                            String labelstr = formatter.sprintfx(value);
                            Object object = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
                        }
                    }
                    if (label == null) break;
                    float labelWidth = GraphicUtils.stringWidth(label, g2d);
                    float x = tickX - (float)((int)(0.5 * (double)labelWidth));
                    if (x < this.minX_) {
                        x = this.minX_;
                    }
                    if (x + labelWidth > this.maxX_) {
                        x = this.maxX_ - labelWidth;
                    }
                    if (this.vectorSampleVis_ && x + labelWidth > this.barRight_ + this.outlierGap_ + this.outlierWidth_) {
                        x = this.barRight_ + this.outlierGap_ + this.outlierWidth_ - labelWidth;
                    }
                    GraphicUtils.drawString(g2d, label, x, this.ticksY_);
                    break;
                }
                case MINOR: {
                    ttop = this.barBottomY_ - 0.2f * this.barThickness_;
                    tbottom = this.barBottomY_ + 0.1f * this.barThickness_;
                    break;
                }
                default: {
                    ttop = this.barBottomY_ - 0.1f * this.barThickness_;
                    tbottom = this.barBottomY_;
                }
            }
            if (Math.abs(tickX - this.barLeft_) < 0.25f && !this.outlierFlushLeft_) {
                ttop = this.barBottomY_;
            } else if (Math.abs(tickX - this.barRight_) < 0.25f && !this.outlierFlushRight_) {
                ttop = this.barBottomY_;
            }
            if (ttop == tbottom) continue;
            GraphicUtils.drawLine(g2d, tickX, ttop, tickX, tbottom);
        }
    }

    private void drawSampleVector(Graphics2D g2d) {
        String label;
        if (!this.vectorSampleVis_) {
            return;
        }
        double referenceVal = this.pmeta_.getDouble("vector.refvalue");
        if (referenceVal <= 0.0) {
            return;
        }
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PrintfFormat formatter = smeta.getFormatter();
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.vectorStroke_);
        float vecy = this.barBottomY_ - 4.0f;
        if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
            double radius = Math.sqrt(0.2 * (double)this.vectorLength_);
            if (radius < 1.25) {
                radius = 1.25;
            }
            Ellipse2D.Double dot = new Ellipse2D.Double((double)this.vectorLeft_ - radius, (double)vecy - radius, radius * 2.0, radius * 2.0);
            g2d.fill(dot);
            GeneralPath line = new GeneralPath();
            line.moveTo(this.vectorLeft_, vecy);
            line.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            g2d.draw(line);
        } else {
            int hlength = (int)(0.25 * (double)this.vectorLength_);
            float hlengthX = (float)((double)hlength * COS45);
            GeneralPath arrow = new GeneralPath();
            arrow.moveTo(this.vectorLeft_, vecy);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            arrow.moveTo(this.vectorLeft_ + this.vectorLength_ - hlengthX, vecy - hlengthX);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_, vecy);
            arrow.lineTo(this.vectorLeft_ + this.vectorLength_ - hlengthX, vecy + hlengthX);
            g2d.draw(arrow);
        }
        String labelstr = formatter.sprintfx(referenceVal);
        String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        if (label != null) {
            float labelWidth = GraphicUtils.stringWidth(label, g2d);
            int dtext = (int)(this.vectorLength_ - labelWidth) / 2;
            float textLeft = this.vectorLeft_ + (float)dtext;
            if (textLeft + labelWidth > this.maxX_) {
                textLeft = this.maxX_ - labelWidth;
            }
            GraphicUtils.drawString(g2d, (Object)label, textLeft, this.ticksY_);
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("size.factor") || pname.contains("colorbar.border.weight")) {
            this.tickStroke_ = PanGraphicUtils.solidStroke(100, sfactor);
            this.borderWgt_ = PanPlotConstraints.constrainColorbarBorderWeight(this.pmeta_.getInt("colorbar.border.weight"));
            this.borderStroke_ = PanGraphicUtils.solidStroke(this.borderWgt_, sfactor);
        }
        if (changeAll || pname.contains("scale.label.custom") || pname.contains("scale.label.text")) {
            this.useCustomCaption_ = this.pmeta_.getBoolean("scale.label.custom");
            this.customCaption_ = this.pmeta_.getString("scale.label.text");
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.label.location")) {
            String s = this.pmeta_.getString("colorbar.label.location");
            this.captionLoc_ = PanColorbarLabelLocation.matching(s);
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.name")) {
            this.clut_ = this.pmeta_.getScaleMeta().getColorTable();
        }
        if (changeAll || pname.contains("colorbar.length")) {
            this.lengthFrac_ = 0.01f * (float)PanPlotConstraints.constrainColorbarLength(this.pmeta_.getInt("colorbar.length"));
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.reverse")) {
            this.clutReversed_ = this.pmeta_.getBoolean("colorbar.reverse");
        }
        if (changeAll || pname.contains("colorbar.tick.length")) {
            this.tickLength_ = PanColorbarTickLength.matching(this.pmeta_.getString("colorbar.tick.length"));
            if (this.tickLength_ == null) {
                this.tickLength_ = PanColorbarTickLength.SHORT;
            }
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("scale.tick.size") || pname.contains("scale.label.size")) {
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.outlier.side") || pname.contains("colorbar.outlier.shape") || pname.contains("colorbar.outlier.gap")) {
            this.ogap_ = PanColorbarOutlierGap.matching(this.pmeta_.getString("colorbar.outlier.gap"));
            this.oshape_ = ColorTableOutlierShape.matching(this.pmeta_.getString("colorbar.outlier.shape"));
            this.oside_ = PanColorbarOutlierSide.matching(this.pmeta_.getString("colorbar.outlier.side"));
            this.outlierOnLeft_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.LEFT;
            this.outlierOnRight_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.RIGHT;
            this.outlierFlushLeft_ = this.outlierOnLeft_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.outlierFlushRight_ = this.outlierOnRight_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.needsMeasurement_ = true;
        }
        if ((changeAll || pname.contains("combination") || pname.contains("vector.sample") || pname.contains("vector.color") || pname.contains("vector.weight") || pname.contains("vector.style") || pname.contains("vector.refvalue")) && this.pmeta_.getType().supportsVectorPlots()) {
            PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
            boolean vis = this.pmeta_.getBoolean("vector.sample");
            boolean bl = this.vectorSampleVis_ = vis && ctype != null && ctype == PanCombinationType.VECTOR;
            if (this.vectorSampleVis_) {
                String vs = this.pmeta_.getString("vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanPlotConstraints.constrainVectorWeight(this.pmeta_.getInt("vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanPlotConstraints.constrainVectorWeight(this.pmeta_.getInt("vector.weight"));
                } else {
                    this.vectorSampleVis_ = false;
                }
            }
            if (this.vectorSampleVis_ && this.vectorWeight_ > 0) {
                this.vectorStroke_ = GraphicUtils.buttMiterStroke(this.vectorWeight_);
            }
            this.needsMeasurement_ = true;
        }
    }
}

