/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.ColorTableOutlierShape;
import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.panoply.action.PanFitScaleToClutAction;
import gov.nasa.giss.panoply.action.PanReverseColorbarAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanColorbarTickLength;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleControlsCC
extends PanScaleControls
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanColorTableComboBox clutCombo_;
    private PanCheckBox reversedCB_;
    private ColorComboBox invColorCombo_;
    private PanCheckBox autofitCB_;
    private DescribedEnumComboBox cbarLocCombo_;
    private PanIntSpinner cbarLengthSpinner_;
    private DescribedEnumComboBox outlierShapeCombo_;
    private DescribedEnumComboBox outlierSideCombo_;
    private DescribedEnumComboBox outlierGapCombo_;
    private DescribedEnumComboBox cbarLabelLocCombo_;
    private DescribedEnumComboBox tickLengthCombo_;
    private PanIntSpinner borderWgtSpinner_;
    private boolean refreshing_;

    public PanScaleControlsCC(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.data_.addDataListener(this);
        PanResourceUtils.getColorTableList().addListDataListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        AbstractAction a = new PanReverseColorbarAction(this.pmeta_);
        this.pmeta_.putAction("reverse-scale", a);
        plotMenu.getItemForName("reverse-scale").setAction(a);
        plotMenu.getItemForName("reverse-scale").setSelected(this.pmeta_.getBoolean("colorbar.reverse"));
        a = new PanFitScaleToClutAction(this.pmeta_, this);
        plotMenu.getItemForName("fit-scale-to-clut").setAction(a);
        this.pmeta_.putAction("fit-scale-to-clut", a);
    }

    private void createLayout() {
        JLabel rangeLabel = new JLabel("Range: ");
        JLabel minLabel = new JLabel("Min.:\u2009");
        JLabel maxLabel = new JLabel(", Max.:\u2009");
        JLabel autofitLabel = new JLabel(" \u2014 ");
        this.autofitCB_ = PanCheckBox.small("scale.autofit", this.pmeta_.getAction("autofit-scale"));
        this.autofitCB_.setText("Always fit");
        QuickBox rangeBox = QuickBox.createLeftBox(rangeLabel, minLabel, this.val1TF_, maxLabel, this.val2TF_, this.fitToDataBtn_, autofitLabel, this.autofitCB_);
        JLabel unitsLabel1 = new JLabel("Units:\u2009");
        JLabel unitsLabel2 = new JLabel("of\u2009");
        JLabel scalingLabel = new JLabel("\u00d7 ");
        JLabel tenLabel = new JLabel("\u00d7 10^");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_, scalingLabel, this.coeffTF_, tenLabel, this.expSpinner_);
        JLabel ticksLabel = new JLabel("Ticks: ");
        JLabel divLabel1 = new JLabel("Divisions: Major:\u2009");
        JLabel divLabel2 = new JLabel("\u2014 Minor:\u2009");
        QuickBox tickDivsBox = QuickBox.createLeftBox(ticksLabel, divLabel1, this.majorDivSpinner_, divLabel2, this.minorDivSpinner_);
        JLabel tickLengthPad = new JLabel(" ");
        JLabel tickLengthLabel = new JLabel("Major Tick Length:\u2009");
        this.tickLengthCombo_ = new DescribedEnumComboBox(PanColorbarTickLength.class);
        this.tickLengthCombo_.setName("colorbar.tick.length");
        QuickBox tickLengthBox = QuickBox.createLeftBox(tickLengthPad, tickLengthLabel, this.tickLengthCombo_);
        JLabel tickLabelPad = new JLabel(" ");
        JLabel tickLabelFormat = new JLabel("Labels: Format:\u2009");
        JLabel tickLabelSize = new JLabel("\u2014 Size:\u2009");
        QuickBox tickLabelsBox = QuickBox.createLeftBox(tickLabelPad, tickLabelFormat, this.tickFormatCombo_, tickLabelSize, this.tickSizeCombo_);
        JLabel cbarLabel = new JLabel("Colorbar: ");
        JLabel clutLabel = new JLabel("Color Table:\u2009");
        this.clutCombo_ = PanColorTableComboBox.small("colorbar.name", true);
        JLabel reversedLabel = new JLabel(" \u2014 ");
        this.reversedCB_ = PanCheckBox.small("colorbar.reverse", this.pmeta_.getAction("reverse-scale"));
        this.reversedCB_.setText("Reverse colors");
        QuickBox ctableBox = QuickBox.createLeftBox(cbarLabel, clutLabel, this.clutCombo_, reversedLabel, this.reversedCB_);
        JLabel invalidsPadLabel = new JLabel(" ");
        JLabel invalidsLabel = new JLabel("Fill Color:\u2009");
        this.invColorCombo_ = new ColorComboBox(PaletteType.GRAYSCALE);
        this.invColorCombo_.setName("colorbar.invalids");
        QuickBox invalidsBox = QuickBox.createLeftBox(invalidsPadLabel, invalidsLabel, this.invColorCombo_);
        JLabel cbarLocPadLabel = new JLabel(" ");
        JLabel cbarLocLabel = new JLabel("Location:\u2009");
        this.cbarLocCombo_ = new DescribedEnumComboBox(PanColorbarLocation.class);
        this.cbarLocCombo_.setName("colorbar.location");
        JLabel widthLabel = new JLabel("\u2014 Length:\u2009");
        this.cbarLengthSpinner_ = PanIntSpinner.small("colorbar.length", this.pmeta_.getInt("colorbar.length"), 50, 100, 5);
        JLabel widthPctLabel = new JLabel("%");
        QuickBox cbarLocBox = QuickBox.createLeftBox(cbarLocPadLabel, cbarLocLabel, this.cbarLocCombo_, widthLabel, this.cbarLengthSpinner_, widthPctLabel);
        this.outlierSideCombo_ = new DescribedEnumComboBox(PanColorbarOutlierSide.class);
        this.outlierShapeCombo_ = new DescribedEnumComboBox(ColorTableOutlierShape.class);
        this.outlierGapCombo_ = new DescribedEnumComboBox(PanColorbarOutlierGap.class);
        this.outlierSideCombo_.setName("colorbar.outlier.side");
        this.outlierShapeCombo_.setName("colorbar.outlier.shape");
        this.outlierGapCombo_.setName("colorbar.outlier.gap");
        JLabel outlierPadLabel = new JLabel(" ");
        JLabel outlierLabel1 = new JLabel("Outliers on:\u2009");
        JLabel outlierLabel2 = new JLabel("\u2014 Shape:\u2009");
        JLabel outlierLabel3 = new JLabel("\u2014 Gap:\u2009");
        QuickBox outlierBox = QuickBox.createLeftBox(outlierPadLabel, outlierLabel1, this.outlierSideCombo_, outlierLabel2, this.outlierShapeCombo_, outlierLabel3, this.outlierGapCombo_);
        JLabel borderPadLabel = new JLabel(" ");
        JLabel borderWgtLabel = new JLabel("Border Weight:\u2009");
        this.borderWgtSpinner_ = PanIntSpinner.smallWeight("colorbar.border.weight", this.pmeta_.getInt("colorbar.border.weight"), 0, 150);
        QuickBox borderWgtBox = QuickBox.createLeftBox(borderPadLabel, borderWgtLabel, this.borderWgtSpinner_);
        JLabel captionLabel = new JLabel("Caption: ");
        JLabel captionSizeLabel = new JLabel("\u2014 Size:\u2009");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel, this.dfltCapBtn_, this.customCapBtn_, this.captionTF_, captionSizeLabel, this.captionSizeCombo_);
        JLabel captionPadLabel = new JLabel(" ");
        JLabel captionPlaceLabel = new JLabel("Location:\u2009");
        this.cbarLabelLocCombo_ = new DescribedEnumComboBox(PanColorbarLabelLocation.class);
        this.cbarLabelLocCombo_.setName("colorbar.label.location");
        QuickBox captionPlaceBox = QuickBox.createLeftBox(captionPadLabel, captionPlaceLabel, this.cbarLabelLocCombo_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(rangeBox);
        this.add(Box.createVerticalStrut(1));
        this.add(unitsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(ctableBox);
        this.add(Box.createVerticalStrut(1));
        this.add(invalidsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(cbarLocBox);
        this.add(Box.createVerticalStrut(1));
        this.add(outlierBox);
        this.add(Box.createVerticalStrut(1));
        this.add(borderWgtBox);
        this.add(Box.createVerticalStrut(1));
        this.add(tickDivsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(tickLabelsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(tickLengthBox);
        this.add(Box.createVerticalStrut(1));
        this.add(captionBox);
        this.add(Box.createVerticalStrut(1));
        this.add(captionPlaceBox);
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(rangeLabel, unitsLabel1, cbarLabel, invalidsPadLabel, cbarLocPadLabel, outlierPadLabel, borderPadLabel, ticksLabel, tickLabelPad, tickLengthPad, captionLabel, captionPadLabel);
        this.val1TF_.setMaximumSize(this.val1TF_.getPreferredSize());
        this.val2TF_.setMaximumSize(this.val2TF_.getPreferredSize());
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
    }

    private void attachListeners() {
        this.clutCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.clutCombo_.isRefreshing()) {
                return;
            }
            Object item = this.clutCombo_.getSelectedItem();
            this.pmeta_.setString("colorbar.name", item.toString());
            this.refreshActions();
        });
        this.cbarLengthSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("colorbar.length", this.cbarLengthSpinner_.getIntValue());
        });
        this.cbarLocCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String item = this.cbarLocCombo_.getEnumName();
            this.pmeta_.setString("colorbar.location", item.toString());
            this.refreshCbarLabelLocation();
        });
        this.invColorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.invColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("colorbar.invalids"))) {
                this.pmeta_.setColor("colorbar.invalids", cnew);
            }
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.shape", this.outlierShapeCombo_.getEnumName());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.side", this.outlierSideCombo_.getEnumName());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.gap", this.outlierGapCombo_.getEnumName());
        });
        this.cbarLabelLocCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.label.location", this.cbarLabelLocCombo_.getEnumName());
        });
        this.borderWgtSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("colorbar.border.weight", this.borderWgtSpinner_.getIntValue());
        });
        this.tickLengthCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.tick.length", this.tickLengthCombo_.getEnumName());
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.autofitCB_.setSelected(this.pmeta_.getBoolean("scale.autofit"));
        this.clutCombo_.setSelectedItemByName(this.pmeta_.getString("colorbar.name"));
        this.reversedCB_.setSelected(this.pmeta_.getBoolean("colorbar.reverse"));
        this.invColorCombo_.setSelectedColor(this.pmeta_.getColor("colorbar.invalids"));
        this.cbarLocCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.location"));
        this.cbarLengthSpinner_.setValue(this.pmeta_.getInt("colorbar.length"));
        this.borderWgtSpinner_.setValue(this.pmeta_.getInt("colorbar.border.weight"));
        this.cbarLabelLocCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.label.location"));
        this.outlierSideCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.outlier.side"));
        this.outlierShapeCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.outlier.shape"));
        this.outlierGapCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.outlier.gap"));
        this.tickLengthCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.tick.length"));
        this.refreshCbarLabelLocation();
        boolean incColorbar = this.pmeta_.getBoolean("include.colorbar");
        this.dfltCapBtn_.setEnabled(incColorbar);
        this.customCapBtn_.setEnabled(incColorbar);
        this.captionTF_.setEnabled(incColorbar);
        this.cbarLabelLocCombo_.setEnabled(incColorbar);
        this.tickSizeCombo_.setEnabled(incColorbar);
        if (incColorbar) {
            boolean capVis = !this.cbarLabelLocCombo_.getSelectedItem().equals(PanColorbarLabelLocation.NONE);
            this.customCapBtn_.setEnabled(capVis);
            this.captionTF_.setEnabled(capVis);
            this.captionSizeCombo_.setEnabled(capVis);
            if (capVis && this.customCapBtn_.isSelected()) {
                this.captionTF_.setText(this.pmeta_.getString("scale.label.text"));
            }
        }
        this.refreshActions();
        this.refreshing_ = false;
    }

    private void refreshCbarLabelLocation() {
        boolean containsBelow;
        boolean bl = containsBelow = this.cbarLabelLocCombo_.getItemCount() == 3;
        if (this.cbarLocCombo_.getSelectedItem().equals(PanColorbarLocation.BELOW)) {
            if (!containsBelow) {
                LOGGER.trace("Add BELOW label");
                this.cbarLabelLocCombo_.insertItemAt(PanColorbarLabelLocation.BELOW, 1);
            }
        } else if (containsBelow) {
            LOGGER.trace("Remove BELOW label");
            this.cbarLabelLocCombo_.removeItem(PanColorbarLabelLocation.BELOW);
        }
        this.cbarLabelLocCombo_.setSelItemMatching(this.pmeta_.getString("colorbar.label.location"));
    }

    private void refreshActions() {
        AbstractColorTable clut = (AbstractColorTable)this.clutCombo_.getSelectedItem();
        boolean clutHasRange = clut.hasRangeLimits();
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        this.pmeta_.getAction("fit-scale-to-clut").setEnabled(clutHasRange && !autoScaleOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanScaleControlsCC panScaleControlsCC = this;
        synchronized (panScaleControlsCC) {
            if (this.clutCombo_ != null) {
                this.clutCombo_.flush();
                this.clutCombo_ = null;
            }
            this.invColorCombo_ = null;
            super.flush();
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        AbstractColorTable clut;
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe && (clut = PanResourceUtils.getColorTable(e.getIndex0())) != null) {
            EventQueue.invokeLater(() -> this.clutCombo_.setSelectedItem(clut));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean newval;
        boolean oldval;
        if (e == null) {
            return;
        }
        super.plotPropertyChanged(e);
        String pname = e.getMessage();
        boolean changeAll = false;
        if (pname.contains("scale.autofit")) {
            oldval = this.autofitCB_.isSelected();
            newval = this.pmeta_.getBoolean("scale.autofit");
            if (newval ^ oldval) {
                this.autofitCB_.setSelected(newval);
            }
        }
        if (pname.contains("colorbar.reverse")) {
            oldval = this.reversedCB_.isSelected();
            newval = this.pmeta_.getBoolean("colorbar.reverse");
            if (newval ^ oldval) {
                this.reversedCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.colorbar") || pname.contains("colorbar.label.location")) {
            this.refreshPrivate();
        }
    }
}

