/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class BrushMetalUtils {
    private static final Color BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 153);
    private static final Color ACTIVE_TOP_COLOR = new Color(200, 200, 200);
    private static final Color ACTIVE_BOTTOM_COLOR = new Color(167, 167, 167);
    private static final Color INACTIVE_TOP_COLOR = new Color(233, 233, 233);
    private static final Color INACTIVE_BOTTOM_COLOR = new Color(216, 216, 216);
    private static final Color ACTIVE_SHADOW_COLOR = new Color(86, 86, 86);
    private static final Color INACTIVE_SHADOW_COLOR = new Color(153, 153, 153);
    private static GradientPainter focusedPainter_;
    private static GradientPainter unfocusedPainter_;

    public static void paintBrushMetalBackground(Component c, Graphics g) {
        JComponent jc = (JComponent)c;
        if (PlatformUtils.isMacintosh()) {
            JFrame parent = GuiUtils.getParentFrame(jc);
            Object o = parent.getRootPane().getClientProperty("apple.awt.brushMetalLook");
            if (o != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
                return;
            }
            GradientPainter painter = BrushMetalUtils.getBrushMetalPainter(c);
            if (painter != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                painter.paint(g2d, c, c.getWidth(), c.getHeight());
                g2d.dispose();
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static Color getHighlightColor() {
        return BORDER_HIGHLIGHT_COLOR;
    }

    public static Color getShadowColor(boolean focused) {
        return focused ? ACTIVE_SHADOW_COLOR : INACTIVE_SHADOW_COLOR;
    }

    public static GradientPainter getBrushMetalPainter(Component c) {
        if (!PlatformUtils.isMacintosh()) {
            return null;
        }
        if (focusedPainter_ == null) {
            focusedPainter_ = new GradientPainter(ACTIVE_TOP_COLOR, ACTIVE_BOTTOM_COLOR);
            unfocusedPainter_ = new GradientPainter(INACTIVE_TOP_COLOR, INACTIVE_BOTTOM_COLOR);
        }
        if (c.hasFocus() || GuiUtils.isParentWindowFocused(c)) {
            return focusedPainter_;
        }
        return unfocusedPainter_;
    }

    private BrushMetalUtils() {
    }

    static class GradientPainter {
        private final Color topColor_;
        private final Color bottomColor_;

        public GradientPainter(Color topColor, Color bottomColor) {
            this.topColor_ = topColor;
            this.bottomColor_ = bottomColor;
        }

        public void paint(Graphics2D g, Component object, int width, int height) {
            GradientPaint paint = new GradientPaint(0.0f, 1.0f, this.topColor_, 0.0f, height, this.bottomColor_);
            g.setPaint(paint);
            g.fillRect(0, 0, width, height);
        }
    }
}

