/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.Windoid;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindoidFocusListener
implements WindowFocusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    WindoidFocusListener() {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        LOGGER.trace("{}", (Object)ww.getName());
        if (ww instanceof Windoid) {
            Windoid www = (Windoid)ww;
            www.getHeader().setInFocusedWindow(true);
            ww.repaint();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        LOGGER.trace("{}", (Object)ww.getName());
        if (ww instanceof Windoid) {
            Windoid www = (Windoid)ww;
            www.getHeader().setInFocusedWindow(false);
            ww.repaint();
        }
    }
}

