import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.parameter_averages import G16

fig, ax = plt.subplots()

# temp model to get the correct x range
text_model = G16()

# generate the curves and plot them
x = np.arange(text_model.x_range[0],
              text_model.x_range[1],0.1)/u.micron

fAs = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
for cur_fA in fAs:
   ext_model = G16(RvA=3.1, fA=cur_fA)
   ax.plot(x,ext_model(x),label=r'$f_A = ' + str(cur_fA) + '$')

ax.set_xlabel(r'$x$ [$\mu m^{-1}$]')
ax.set_ylabel(r'$A(x)/A(V)$')

# for 2nd x-axis with lambda values
axis_xs = np.array([0.1, 0.12, 0.15, 0.2, 0.3, 0.5, 1.0])
new_ticks = 1 / axis_xs
new_ticks_labels = ["%.2f" % z for z in axis_xs]
tax = ax.twiny()
tax.set_xlim(ax.get_xlim())
tax.set_xticks(new_ticks)
tax.set_xticklabels(new_ticks_labels)
tax.set_xlabel(r"$\lambda$ [$\mu$m]")

ax.legend(loc='best', title=r'$R_A(V) = 3.1$')
plt.show()