/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class VariableGapTermsIndexWriter
extends TermsIndexWriterBase {
    protected IndexOutput metaOut;
    protected IndexOutput out;
    static final String TERMS_INDEX_EXTENSION = "tiv";
    static final String TERMS_META_EXTENSION = "tmv";
    static final String META_CODEC_NAME = "VariableGapTermsMeta";
    static final String CODEC_NAME = "VariableGapTermsIndex";
    static final int VERSION_START = 4;
    static final int VERSION_CURRENT = 4;
    private final FieldInfos fieldInfos;
    private final IndexTermSelector policy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VariableGapTermsIndexWriter(SegmentWriteState state, IndexTermSelector policy) throws IOException {
        this.fieldInfos = state.fieldInfos;
        this.policy = policy;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_META_EXTENSION);
        String indexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
        boolean success = false;
        try {
            this.metaOut = state.directory.createOutput(metaFileName, state.context);
            this.out = state.directory.createOutput(indexFileName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.metaOut, (String)META_CODEC_NAME, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.writeIndexHeader((DataOutput)this.out, (String)CODEC_NAME, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    @Override
    public TermsIndexWriterBase.FieldWriter addField(FieldInfo field, long termsFilePointer) throws IOException {
        this.policy.newField(field);
        return new FSTFieldWriter(field, termsFilePointer);
    }

    protected int indexedTermPrefixLength(BytesRef priorTerm, BytesRef indexedTerm) {
        int idxTermOffset = indexedTerm.offset;
        int priorTermOffset = priorTerm.offset;
        int limit = Math.min(priorTerm.length, indexedTerm.length);
        for (int byteIdx = 0; byteIdx < limit; ++byteIdx) {
            if (priorTerm.bytes[priorTermOffset + byteIdx] == indexedTerm.bytes[idxTermOffset + byteIdx]) continue;
            return byteIdx + 1;
        }
        return Math.min(1 + priorTerm.length, indexedTerm.length);
    }

    @Override
    public void close() throws IOException {
        block9: {
            try {
                if (this.metaOut != null) {
                    this.metaOut.writeInt(-1);
                    CodecUtil.writeFooter((IndexOutput)this.metaOut);
                }
                if (this.out == null) break block9;
                CodecUtil.writeFooter((IndexOutput)this.out);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.out, this.metaOut});
                }
                finally {
                    this.out = null;
                    this.metaOut = null;
                }
                throw throwable;
            }
        }
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.out, this.metaOut});
        }
        finally {
            this.out = null;
            this.metaOut = null;
        }
    }

    public static abstract class IndexTermSelector {
        public abstract boolean isIndexTerm(BytesRef var1, TermStats var2);

        public abstract void newField(FieldInfo var1);
    }

    private class FSTFieldWriter
    extends TermsIndexWriterBase.FieldWriter {
        private final FSTCompiler<Long> fstCompiler;
        private final PositiveIntOutputs fstOutputs;
        private final long startTermsFilePointer;
        final FieldInfo fieldInfo;
        FST<Long> fst;
        private final BytesRefBuilder lastTerm;
        private boolean first;
        private final IntsRefBuilder scratchIntsRef;

        public FSTFieldWriter(FieldInfo fieldInfo, long termsFilePointer) throws IOException {
            super(VariableGapTermsIndexWriter.this);
            this.lastTerm = new BytesRefBuilder();
            this.first = true;
            this.scratchIntsRef = new IntsRefBuilder();
            this.fieldInfo = fieldInfo;
            this.fstOutputs = PositiveIntOutputs.getSingleton();
            this.fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE1, (Outputs)this.fstOutputs).build();
            this.fstCompiler.add(new IntsRef(), (Object)termsFilePointer);
            this.startTermsFilePointer = termsFilePointer;
        }

        @Override
        public boolean checkIndexTerm(BytesRef text, TermStats stats) throws IOException {
            if (VariableGapTermsIndexWriter.this.policy.isIndexTerm(text, stats) || this.first) {
                this.first = false;
                return true;
            }
            this.lastTerm.copyBytes(text);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(BytesRef text, TermStats stats, long termsFilePointer) throws IOException {
            if (text.length == 0) {
                assert (termsFilePointer == this.startTermsFilePointer);
                return;
            }
            int lengthSave = text.length;
            text.length = VariableGapTermsIndexWriter.this.indexedTermPrefixLength(this.lastTerm.get(), text);
            try {
                this.fstCompiler.add(Util.toIntsRef((BytesRef)text, (IntsRefBuilder)this.scratchIntsRef), (Object)termsFilePointer);
            }
            finally {
                text.length = lengthSave;
            }
            this.lastTerm.copyBytes(text);
        }

        @Override
        public void finish(long termsFilePointer) throws IOException {
            this.fst = FST.fromFSTReader((FST.FSTMetadata)this.fstCompiler.compile(), (FSTReader)this.fstCompiler.getFSTReader());
            if (this.fst != null) {
                VariableGapTermsIndexWriter.this.metaOut.writeInt(this.fieldInfo.number);
                VariableGapTermsIndexWriter.this.metaOut.writeVLong(VariableGapTermsIndexWriter.this.out.getFilePointer());
                this.fst.save((DataOutput)VariableGapTermsIndexWriter.this.metaOut, (DataOutput)VariableGapTermsIndexWriter.this.out);
            }
        }
    }

    public static final class EveryNOrDocFreqTermSelector
    extends IndexTermSelector {
        private int count;
        private final int docFreqThresh;
        private final int interval;

        public EveryNOrDocFreqTermSelector(int docFreqThresh, int interval) {
            this.interval = interval;
            this.docFreqThresh = docFreqThresh;
            this.count = interval;
        }

        @Override
        public boolean isIndexTerm(BytesRef term, TermStats stats) {
            if (stats.docFreq() >= this.docFreqThresh || this.count >= this.interval) {
                this.count = 1;
                return true;
            }
            ++this.count;
            return false;
        }

        @Override
        public void newField(FieldInfo fieldInfo) {
            this.count = this.interval;
        }
    }

    public static final class EveryNTermSelector
    extends IndexTermSelector {
        private int count;
        private final int interval;

        public EveryNTermSelector(int interval) {
            this.interval = interval;
            this.count = interval;
        }

        @Override
        public boolean isIndexTerm(BytesRef term, TermStats stats) {
            if (this.count >= this.interval) {
                this.count = 1;
                return true;
            }
            ++this.count;
            return false;
        }

        @Override
        public void newField(FieldInfo fieldInfo) {
            this.count = this.interval;
        }
    }
}

