#ifndef __FVM_HEADERS_H__
#define __FVM_HEADERS_H__

/*============================================================================
 * Global code_saturne headers file for easier include
 *============================================================================*/

/*
  This file is part of code_saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2025 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------
 * Local headers
 *----------------------------------------------------------------------------*/

#include "fvm/fvm_defs.h"
#include "fvm/fvm_group.h"
#include "fvm/fvm_interpolate.h"
#include "fvm/fvm_io_num.h"
#include "fvm/fvm_neighborhood.h"
#include "fvm/fvm_nodal.h"
#include "fvm/fvm_nodal_append.h"
#include "fvm/fvm_nodal_extrude.h"
#include "fvm/fvm_nodal_from_desc.h"
#include "fvm/fvm_nodal_order.h"
#include "fvm/fvm_nodal_project.h"
#include "fvm/fvm_nodal_triangulate.h"
#include "fvm/fvm_nodal_extract.h"
#include "fvm/fvm_periodicity.h"
#include "fvm/fvm_point_location.h"
#include "fvm/fvm_selector.h"
#include "fvm/fvm_trace.h"
#include "fvm/fvm_triangulate.h"
#include "fvm/fvm_writer.h"

/*----------------------------------------------------------------------------*/

#endif /* __FVM_HEADERS_H__ */
