#ifndef __CS_MESH_HEADERS_H__
#define __CS_MESH_HEADERS_H__

/*============================================================================
 * Global code_saturne headers file for easier include
 *============================================================================*/

/*
  This file is part of code_saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2025 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------
 * Local headers
 *----------------------------------------------------------------------------*/

#include "mesh/cs_geom.h"
#include "mesh/cs_join.h"
#include "mesh/cs_join_intersect.h"
#include "mesh/cs_join_merge.h"
#include "mesh/cs_join_mesh.h"
#include "mesh/cs_join_perio.h"
#include "mesh/cs_join_post.h"
#include "mesh/cs_join_set.h"
#include "mesh/cs_join_split.h"
#include "mesh/cs_join_update.h"
#include "mesh/cs_join_util.h"
#include "mesh/cs_mesh.h"
#include "mesh/cs_mesh_adjacencies.h"
#include "mesh/cs_mesh_bad_cells.h"
#include "mesh/cs_mesh_boundary.h"
#include "mesh/cs_mesh_boundary_layer.h"
#include "mesh/cs_mesh_builder.h"
#include "mesh/cs_mesh_cartesian.h"
#include "mesh/cs_mesh_coarsen.h"
#include "mesh/cs_mesh_coherency.h"
#include "mesh/cs_mesh_connect.h"
#if defined(__cplusplus)
#include "mesh/cs_mesh_cut.h"
#endif
#include "mesh/cs_mesh_extrude.h"
#include "mesh/cs_mesh_from_builder.h"
#include "mesh/cs_mesh_group.h"
#include "mesh/cs_mesh_halo.h"
#include "mesh/cs_mesh_intersect.h"
#include "mesh/cs_mesh_location.h"
#include "mesh/cs_mesh_quality.h"
#include "mesh/cs_mesh_quantities.h"
#include "mesh/cs_mesh_refine.h"
#include "mesh/cs_mesh_remove.h"
#include "mesh/cs_mesh_save.h"
#include "mesh/cs_mesh_to_builder.h"
#include "mesh/cs_mesh_warping.h"
#include "mesh/cs_mesh_smoother.h"
#include "mesh/cs_partition.h"
#include "mesh/cs_symmetry_faces_filter.h"

/*----------------------------------------------------------------------------*/

#endif /* __CS_MESH_HEADERS_H__ */
