# * Build details for DOLFINx: Dynamic Object-oriented Library for
# * FINite element computation
#
# This file has been automatically generated.

# FIXME: Check that naming conforms to CMake standards


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was DOLFINXConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/dolfinx" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
include(CMakeFindDependencyMacro)

find_dependency(MPI REQUIRED)
find_dependency(spdlog REQUIRED)
find_dependency(pugixml REQUIRED)

if(POLICY CMP0167)
  cmake_policy(SET CMP0167 NEW)  # Boost CONFIG mode
endif()
if(POLICY CMP0144)
  cmake_policy(SET CMP0144 NEW)  # https://cmake.org/cmake/help/latest/policy/CMP0144.html
endif()

# Check for Boost
if(DEFINED ENV{BOOST_ROOT} OR DEFINED BOOST_ROOT)
  set(Boost_NO_SYSTEM_PATHS on)
endif()
set(Boost_USE_MULTITHREADED $ENV{BOOST_USE_MULTITHREADED})
set(Boost_VERBOSE TRUE)
find_package(Boost 1.70 REQUIRED)

if()
  find_dependency(ufcx)
endif()

# Basix
if(ON)
  find_package(
    Python3
    COMPONENTS Interpreter
    QUIET
  )

  if(Python3_Interpreter_FOUND)
    message(STATUS "Checking for Basix hints with ${Python3_EXECUTABLE}")
    execute_process(
      COMMAND
        ${Python3_EXECUTABLE} -c
        "import basix, os, sys; sys.stdout.write(os.path.dirname(basix.__file__))"
      OUTPUT_VARIABLE BASIX_PY_DIR
      RESULT_VARIABLE BASIX_PY_COMMAND_RESULT
      ERROR_QUIET OUTPUT_STRIP_TRAILING_WHITESPACE
    )
  endif()

  if(BASIX_PY_DIR)
    # TODO: CMake 3.20 has more modern cmake_path.
    file(TO_CMAKE_PATH "${BASIX_PY_DIR}" BASIX_PY_DIR)
    message(STATUS "Adding ${BASIX_PY_DIR} to Basix search hints")
  else()
    message(STATUS "No Basix hint was found.")
  endif()
endif()

find_dependency(Basix REQUIRED CONFIG HINTS ${BASIX_PY_DIR})

# HDF5
if(NOT TARGET hdf5::hdf5)
  set(HDF5_PREFER_PARALLEL TRUE)
  set(HDF5_FIND_DEBUG TRUE)
  find_dependency(HDF5 COMPONENTS C)
  if(HDF5_FOUND AND NOT HDF5_IS_PARALLEL)
    message(FATAL_ERROR "Found serial HDF5 build, MPI HDF5 build required")
  endif()
endif()

if(1)
  if(NOT TARGET PkgConfig::PETSC)
    find_package(PkgConfig REQUIRED)
    set(ENV{PKG_CONFIG_PATH}
        "$ENV{PETSC_DIR}/$ENV{PETSC_ARCH}/lib/pkgconfig:$ENV{PETSC_DIR}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}"
    )
    pkg_search_module(PETSC REQUIRED IMPORTED_TARGET PETSc petsc)
  endif()
endif()

if()
  if(NOT TARGET PkgConfig::SLEPC)
    find_package(PkgConfig REQUIRED)
    set(ENV{PKG_CONFIG_PATH}
        "$ENV{SLEPC_DIR}/$ENV{PETSC_ARCH}/lib/pkgconfig:$ENV{SLEPC_DIR}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}"
    )
    set(ENV{PKG_CONFIG_PATH}
        "$ENV{PETSC_DIR}/$ENV{PETSC_ARCH}/lib/pkgconfig:$ENV{PETSC_DIR}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}"
    )
    set(ENV{PKG_CONFIG_PATH}
        "$ENV{PETSC_DIR}/$ENV{PETSC_ARCH}:$ENV{PETSC_DIR}:$ENV{PKG_CONFIG_PATH}"
    )
    pkg_search_module(SLEPC REQUIRED IMPORTED_TARGET SLEPc slepc)
  endif()
endif()

if(1)
  find_dependency(ADIOS2 2.8.1 COMPONENTS CXX)
endif()

if(NOT TARGET dolfinx)
  include("${CMAKE_CURRENT_LIST_DIR}/DOLFINXTargets.cmake")
endif()

check_required_components(DOLFINX)
