if(NOT dune-common_FOUND)
# Whether this module is installed or not
set(dune-common_INSTALLED ON)

# Settings specific to the module

# Package initialization

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was dune-common-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

#report other information
set_and_check(dune-common_PREFIX "${PACKAGE_PREFIX_DIR}")
set_and_check(dune-common_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(dune-common_CMAKE_CONFIG_VERSION "2.10")
set(dune-common_CXX_FLAGS "-O2 -Wall -fdiagnostics-color=always -mavx")
set(dune-common_CXX_FLAGS_DEBUG "-g")
set(dune-common_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(dune-common_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(dune-common_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(dune-common_DEPENDS "")
set(dune-common_SUGGESTS "")
set(dune-common_MODULE_PATH "${PACKAGE_PREFIX_DIR}/share/dune/cmake/modules")
set(dune-common_PYTHON_WHEELHOUSE "/build/dune-common/src/dune-common-2.10.0/_skbuild/linux-x86_64-3.14/cmake-build/dist")
set(dune-common_LIBRARIES "Dune::Common")
set(dune-common_HASPYTHON 1)
set(dune-common_PYTHONREQUIRES "pip>=21.a portalocker numpy wheel setuptools>=41 jinja2")

# Resolve dune dependencies
include(CMakeFindDependencyMacro)


# Set up DUNE_LIBS, DUNE_FOUND_DEPENDENCIES, DUNE_*_FOUND, and HAVE_* variables
if(dune-common_LIBRARIES)
  message(STATUS "Setting dune-common_LIBRARIES=${dune-common_LIBRARIES}")
  list(PREPEND DUNE_LIBS ${dune-common_LIBRARIES})
endif()
list(APPEND DUNE_FOUND_DEPENDENCIES dune-common)
set(DUNE_dune-common_FOUND TRUE)
set(HAVE_DUNE_COMMON TRUE)

# Lines that are set by the CMake build system via the variable DUNE_CUSTOM_PKG_CONFIG_SECTION
set_and_check(dune-common_SCRIPT_DIR "${PACKAGE_PREFIX_DIR}/share/dune/cmake/scripts")
set_and_check(DOXYSTYLE_FILE "${PACKAGE_PREFIX_DIR}/share/dune-common/doc/doxygen//Doxystyle")
set_and_check(DOXYGENMACROS_FILE "${PACKAGE_PREFIX_DIR}/share/dune-common/doc/doxygen//doxygen-macros")

# If this file is found in a super build that includes dune-common, the 
# `dune-common-targets.cmake`-file has not yet been generated. This variable
# determines whether the configuration of dune-common has been completed.
get_property(dune-common_IN_CONFIG_MODE GLOBAL PROPERTY dune-common_LIBRARIES DEFINED)

#import the target
if(dune-common_LIBRARIES AND NOT dune-common_IN_CONFIG_MODE)
  get_filename_component(_dir "${CMAKE_CURRENT_LIST_FILE}" PATH)
  include("${_dir}/dune-common-targets.cmake")
endif()

endif()
