if(NOT dune-localfunctions_FOUND)
# Whether this module is installed or not
set(dune-localfunctions_INSTALLED ON)

# Settings specific to the module

# Package initialization

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was dune-localfunctions-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

#report other information
set_and_check(dune-localfunctions_PREFIX "${PACKAGE_PREFIX_DIR}")
set_and_check(dune-localfunctions_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(dune-localfunctions_CMAKE_CONFIG_VERSION "2.10")
set(dune-localfunctions_CXX_FLAGS "-O2 -Wall -fdiagnostics-color=always -mavx")
set(dune-localfunctions_CXX_FLAGS_DEBUG "-g")
set(dune-localfunctions_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(dune-localfunctions_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(dune-localfunctions_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(dune-localfunctions_DEPENDS "dune-geometry (>= 2.10)")
set(dune-localfunctions_SUGGESTS "")
set(dune-localfunctions_MODULE_PATH "${PACKAGE_PREFIX_DIR}/share/dune/cmake/modules")
set(dune-localfunctions_PYTHON_WHEELHOUSE "/build/dune-localfunctions/src/dune-localfunctions-2.10.0/_skbuild/linux-x86_64-3.14/cmake-build/dist")
set(dune-localfunctions_LIBRARIES "Dune::LocalFunctions")
set(dune-localfunctions_HASPYTHON 1)
set(dune-localfunctions_PYTHONREQUIRES "")

# Resolve dune dependencies
include(CMakeFindDependencyMacro)
macro(find_and_check_dune_dependency module version)
  find_dependency(${module})
  list(PREPEND CMAKE_MODULE_PATH "${dune-common_MODULE_PATH}")
  include(DuneModuleDependencies)
  list(POP_FRONT CMAKE_MODULE_PATH)
  if(dune-common_VERSION VERSION_GREATER_EQUAL "2.10")
    dune_check_module_version(${module} QUIET REQUIRED VERSION "${version}")
  endif()
endmacro()

find_and_check_dune_dependency(dune-geometry ">= 2.10")

# Set up DUNE_LIBS, DUNE_FOUND_DEPENDENCIES, DUNE_*_FOUND, and HAVE_* variables
if(dune-localfunctions_LIBRARIES)
  message(STATUS "Setting dune-localfunctions_LIBRARIES=${dune-localfunctions_LIBRARIES}")
  list(PREPEND DUNE_LIBS ${dune-localfunctions_LIBRARIES})
endif()
list(APPEND DUNE_FOUND_DEPENDENCIES dune-localfunctions)
set(DUNE_dune-localfunctions_FOUND TRUE)
set(HAVE_DUNE_LOCALFUNCTIONS TRUE)

# Lines that are set by the CMake build system via the variable DUNE_CUSTOM_PKG_CONFIG_SECTION


# If this file is found in a super build that includes dune-localfunctions, the 
# `dune-localfunctions-targets.cmake`-file has not yet been generated. This variable
# determines whether the configuration of dune-localfunctions has been completed.
get_property(dune-localfunctions_IN_CONFIG_MODE GLOBAL PROPERTY dune-localfunctions_LIBRARIES DEFINED)

#import the target
if(dune-localfunctions_LIBRARIES AND NOT dune-localfunctions_IN_CONFIG_MODE)
  get_filename_component(_dir "${CMAKE_CURRENT_LIST_FILE}" PATH)
  include("${_dir}/dune-localfunctions-targets.cmake")
endif()

endif()
