/*
 * (C) Copyright 2011- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#ifndef ECCODES_ecbuild_config_h
#define ECCODES_ecbuild_config_h

/* ecbuild info */

#ifndef ECBUILD_VERSION_STR
#define ECBUILD_VERSION_STR "3.12.0"
#endif
#ifndef ECBUILD_VERSION
#define ECBUILD_VERSION "3.12.0"
#endif
#ifndef ECBUILD_MACROS_DIR
#define ECBUILD_MACROS_DIR  "/build/eccodes/src/eccodes-2.45.0-Source/cmake"
#endif

/* config info */

#define ECCODES_OS_NAME          "Linux-6.11.0-1018-azure"
#define ECCODES_OS_BITS          64
#define ECCODES_OS_BITS_STR      "64"
#define ECCODES_OS_STR           "linux.64"
#define ECCODES_OS_VERSION       "6.11.0-1018-azure"
#define ECCODES_SYS_PROCESSOR    "x86_64"

#define ECCODES_BUILD_TIMESTAMP  "20260125024908"
#define ECCODES_BUILD_TYPE       "None"

#define ECCODES_C_COMPILER_ID      "GNU"
#define ECCODES_C_COMPILER_VERSION "15.2.1"

#define ECCODES_CXX_COMPILER_ID      "GNU"
#define ECCODES_CXX_COMPILER_VERSION "15.2.1"

#define ECCODES_C_COMPILER       "/usr/bin/cc"
#define ECCODES_C_FLAGS          "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -flto=auto -pipe "

#define ECCODES_CXX_COMPILER     "/usr/bin/c++"
#define ECCODES_CXX_FLAGS        "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -flto=auto -pipe "

/* Needed for finding per package config files */

#define ECCODES_INSTALL_DIR       "/usr"
#define ECCODES_INSTALL_BIN_DIR   "/usr/bin"
#define ECCODES_INSTALL_LIB_DIR   "/usr/lib"
#define ECCODES_INSTALL_DATA_DIR  "/usr/share/eccodes"

#define ECCODES_DEVELOPER_SRC_DIR "/build/eccodes/src/eccodes-2.45.0-Source"
#define ECCODES_DEVELOPER_BIN_DIR "/build/eccodes/src/build"

/* Fortran support */

#if 1

#define ECCODES_Fortran_COMPILER_ID      "GNU"
#define ECCODES_Fortran_COMPILER_VERSION "15.2.1"

#define ECCODES_Fortran_COMPILER "/usr/bin/gfortran"
#define ECCODES_Fortran_FLAGS    "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt         -Wp,-D_FORTIFY_SOURCE=3 -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer "

#endif

#endif /* ECCODES_ecbuild_config_h */
