/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import org.jabref.gui.DialogService;
import org.jabref.gui.util.UiTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackExceptionHandler.class);

    public static void installExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new FallbackExceptionHandler());
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        LOGGER.error("Uncaught exception occurred in " + String.valueOf(thread), exception);
        UiTaskExecutor.runInJavaFXThread(() -> {
            DialogService dialogService = (DialogService)Injector.instantiateModelOrService(DialogService.class);
            dialogService.showErrorDialogAndWait("Uncaught exception occurred in " + String.valueOf(thread), exception);
        });
    }
}

