/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import mslinks.ShellLink;
import mslinks.ShellLinkException;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.preferences.FilePreferences;
import org.slf4j.LoggerFactory;

public class Windows
extends NativeDesktop {
    private static final String DEFAULT_EXECUTABLE_EXTENSION = ".exe";

    @Override
    public void openFile(String filePath, String fileType, FilePreferences filePreferences) throws IOException {
        Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByExt(fileType, filePreferences);
        if (type.isPresent() && !type.get().getOpenWithApplication().isEmpty()) {
            this.openFileWithApplication(filePath, type.get().getOpenWithApplication());
        } else {
            String quotePath = "\"" + filePath + "\"";
            new ProcessBuilder("explorer.exe", quotePath).start();
        }
    }

    @Override
    public String detectProgramPath(String programName, String directoryName) {
        String programPath;
        String progFiles;
        Path texworksLinkPath;
        if (Objects.equals(programName, "texworks") && Files.exists(texworksLinkPath = Path.of(System.getenv("APPDATA") + "\\Microsoft\\Windows\\Start Menu\\Programs\\MiKTeX\\TeXworks.lnk", new String[0]), new LinkOption[0])) {
            try {
                ShellLink link = new ShellLink(texworksLinkPath);
                return link.resolveTarget();
            }
            catch (IOException | ShellLinkException e) {
                Logger logger = Logger.getLogger(Windows.class.getName());
                logger.log(Level.WARNING, "Had an error while reading .lnk file for TeXworks", e);
            }
        }
        if ((progFiles = System.getenv("ProgramFiles(x86)")) != null && (programPath = this.getProgramPath(programName, directoryName, progFiles)) != null) {
            return programPath;
        }
        progFiles = System.getenv("ProgramFiles");
        programPath = this.getProgramPath(programName, directoryName, progFiles);
        if (programPath != null) {
            return programPath;
        }
        return "";
    }

    private String getProgramPath(String programName, String directoryName, String progFiles) {
        Path programPath = directoryName != null && !directoryName.isEmpty() ? Path.of(progFiles, directoryName, programName + DEFAULT_EXECUTABLE_EXTENSION) : Path.of(progFiles, programName + DEFAULT_EXECUTABLE_EXTENSION);
        if (Files.exists(programPath, new LinkOption[0])) {
            return programPath.toString();
        }
        return null;
    }

    @Override
    public Path getApplicationDirectory() {
        String programDir = System.getenv("ProgramFiles");
        if (programDir != null) {
            return Path.of(programDir, new String[0]);
        }
        return this.getUserDirectory();
    }

    @Override
    public Path getDefaultFileChooserDirectory() {
        try {
            try {
                return Path.of(Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_Documents), new String[0]);
            }
            catch (UnsatisfiedLinkError e) {
                return Path.of(Shell32Util.getFolderPath((int)5), new String[0]);
            }
        }
        catch (Win32Exception e) {
            LoggerFactory.getLogger(Windows.class).error("Error accessing folder", (Throwable)e);
            return Path.of(System.getProperty("user.home"), new String[0]);
        }
    }

    @Override
    public void openFileWithApplication(String filePath, String application) throws IOException {
        new ProcessBuilder(Path.of(application, new String[0]).toString(), Path.of(filePath, new String[0]).toString()).start();
    }

    @Override
    public void openFolderAndSelectFile(Path filePath) throws IOException {
        new ProcessBuilder("explorer.exe", "/select,", filePath.toString()).start();
    }

    @Override
    public void openConsole(String absolutePath, DialogService dialogService) throws IOException {
        ProcessBuilder process = new ProcessBuilder("cmd.exe", "/c", "start");
        process.directory(new File(absolutePath));
        process.start();
    }
}

