/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entrytype;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.externalfiles.ImportHandler;
import org.jabref.gui.importer.NewEntryAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.importer.fetcher.DoiFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryTypeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryTypeViewModel.class);
    private final PreferencesService preferencesService;
    private final BooleanProperty searchingProperty = new SimpleBooleanProperty();
    private final BooleanProperty searchSuccesfulProperty = new SimpleBooleanProperty();
    private final ObjectProperty<IdBasedFetcher> selectedItemProperty = new SimpleObjectProperty();
    private final ListProperty<IdBasedFetcher> fetchers = new SimpleListProperty(FXCollections.observableArrayList());
    private final StringProperty idText = new SimpleStringProperty();
    private final BooleanProperty focusAndSelectAllProperty = new SimpleBooleanProperty();
    private Task<Optional<BibEntry>> fetcherWorker = new FetcherWorker();
    private final LibraryTab libraryTab;
    private final DialogService dialogService;
    private final Validator idFieldValidator;
    private final StateManager stateManager;
    private final TaskExecutor taskExecutor;
    private final FileUpdateMonitor fileUpdateMonitor;

    public EntryTypeViewModel(PreferencesService preferences, LibraryTab libraryTab, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, FileUpdateMonitor fileUpdateMonitor) {
        this.libraryTab = libraryTab;
        this.preferencesService = preferences;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.fetchers.addAll(WebFetchers.getIdBasedFetchers(preferences.getImportFormatPreferences(), preferences.getImporterPreferences()));
        this.selectedItemProperty.setValue((Object)this.getLastSelectedFetcher());
        this.idFieldValidator = new FunctionBasedValidator((ObservableValue)this.idText, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Required field \"%0\" is empty.", Localization.lang("ID", new Object[0]))));
    }

    public BooleanProperty searchSuccesfulProperty() {
        return this.searchSuccesfulProperty;
    }

    public BooleanProperty searchingProperty() {
        return this.searchingProperty;
    }

    public ObjectProperty<IdBasedFetcher> selectedItemProperty() {
        return this.selectedItemProperty;
    }

    public ValidationStatus idFieldValidationStatus() {
        return this.idFieldValidator.getValidationStatus();
    }

    public StringProperty idTextProperty() {
        return this.idText;
    }

    public BooleanProperty getFocusAndSelectAllProperty() {
        return this.focusAndSelectAllProperty;
    }

    public void storeSelectedFetcher() {
        this.preferencesService.getGuiPreferences().setLastSelectedIdBasedFetcher(((IdBasedFetcher)this.selectedItemProperty.getValue()).getName());
    }

    private IdBasedFetcher getLastSelectedFetcher() {
        return this.fetchers.stream().filter(fetcher -> fetcher.getName().equals(this.preferencesService.getGuiPreferences().getLastSelectedIdBasedFetcher())).findFirst().orElse(new DoiFetcher(this.preferencesService.getImportFormatPreferences()));
    }

    public ListProperty<IdBasedFetcher> fetcherItemsProperty() {
        return this.fetchers;
    }

    public void stopFetching() {
        if (this.fetcherWorker.getState() == Worker.State.RUNNING) {
            this.fetcherWorker.cancel(true);
        }
    }

    public void runFetcherWorker() {
        this.fetcherWorker.setOnRunning(event -> this.searchingProperty().setValue(Boolean.valueOf(true)));
        this.fetcherWorker.setOnFailed(event -> {
            this.searchSuccesfulProperty.set(false);
            Throwable exception = this.fetcherWorker.getException();
            String fetcherExceptionMessage = exception.getMessage();
            String fetcher = ((IdBasedFetcher)this.selectedItemProperty().getValue()).getName();
            String searchId = this.idText.getValue();
            if (exception instanceof FetcherClientException) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Failed to import by ID", new Object[0]), Localization.lang("Bibliographic data not found. Cause is likely the client side. Please check connection and identifier for correctness.", new Object[0]) + "\n" + fetcherExceptionMessage);
            } else if (exception instanceof FetcherServerException) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Failed to import by ID", new Object[0]), Localization.lang("Bibliographic data not found. Cause is likely the server side. Please try again later.", new Object[0]) + "\n" + fetcherExceptionMessage);
            } else {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Failed to import by ID", new Object[0]), Localization.lang("Error message %0", fetcherExceptionMessage));
            }
            LOGGER.error("Exception during fetching when using fetcher '{}' with entry id '{}'.", new Object[]{fetcher, searchId, exception});
            this.searchingProperty.set(false);
            this.fetcherWorker = new FetcherWorker();
        });
        this.fetcherWorker.setOnSucceeded(evt -> {
            Optional result = (Optional)this.fetcherWorker.getValue();
            if (result.isPresent()) {
                BibEntry entry = (BibEntry)result.get();
                ImportHandler handler = new ImportHandler(this.libraryTab.getBibDatabaseContext(), this.preferencesService, this.fileUpdateMonitor, this.libraryTab.getUndoManager(), this.stateManager, this.dialogService, this.taskExecutor);
                handler.importEntryWithDuplicateCheck(this.libraryTab.getBibDatabaseContext(), entry);
                this.searchSuccesfulProperty.set(true);
            } else if (StringUtil.isBlank(this.idText.getValue())) {
                this.dialogService.showWarningDialogAndWait(Localization.lang("Empty search ID", new Object[0]), Localization.lang("The given search ID was empty.", new Object[0]));
            } else {
                String fetcher = ((IdBasedFetcher)this.selectedItemProperty().getValue()).getName();
                String searchId = this.idText.getValue();
                boolean addEntryFlag = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Identifier not found", new Object[0]), Localization.lang("Fetcher '%0' did not find an entry for id '%1'.", fetcher, searchId), Localization.lang("Add entry manually", new Object[0]), Localization.lang("Return to dialog", new Object[0]));
                if (addEntryFlag) {
                    new NewEntryAction(() -> this.libraryTab, StandardEntryType.Article, this.dialogService, this.preferencesService, this.stateManager).execute();
                    this.searchSuccesfulProperty.set(true);
                }
            }
            this.focusAndSelectAllProperty.set(true);
            this.searchingProperty().set(false);
            this.fetcherWorker = new FetcherWorker();
        });
        this.taskExecutor.execute(this.fetcherWorker);
    }

    public void cancelFetcherWorker() {
        this.fetcherWorker.cancel();
    }

    private class FetcherWorker
    extends Task<Optional<BibEntry>> {
        private IdBasedFetcher fetcher = null;
        private String searchID = "";

        private FetcherWorker() {
        }

        protected Optional<BibEntry> call() throws FetcherException {
            EntryTypeViewModel.this.storeSelectedFetcher();
            this.fetcher = (IdBasedFetcher)EntryTypeViewModel.this.selectedItemProperty().getValue();
            this.searchID = EntryTypeViewModel.this.idText.getValue();
            if (this.searchID.isEmpty()) {
                return Optional.empty();
            }
            return this.fetcher.performSearchById(this.searchID);
        }
    }
}

