/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.errorconsole;

import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.logic.util.OS;
import org.tinylog.core.LogEntry;

public class LogEventViewModel {
    private final LogEntry logEvent;

    public LogEventViewModel(LogEntry logEvent) {
        this.logEvent = Objects.requireNonNull(logEvent);
    }

    public String getDisplayText() {
        return this.logEvent.getMessage();
    }

    public String getStyleClass() {
        switch (this.logEvent.getLevel()) {
            case ERROR: {
                return "exception";
            }
            case WARN: {
                return "output";
            }
        }
        return "log";
    }

    public JabRefIcon getIcon() {
        switch (this.logEvent.getLevel()) {
            case ERROR: {
                return IconTheme.JabRefIcons.INTEGRITY_FAIL;
            }
            case WARN: {
                return IconTheme.JabRefIcons.INTEGRITY_WARN;
            }
        }
        return IconTheme.JabRefIcons.INTEGRITY_INFO;
    }

    public Optional<String> getStackTrace() {
        return Optional.ofNullable(this.logEvent.getException()).map(Throwables::getStackTraceAsString);
    }

    public String getDetailedText() {
        return this.getDisplayText() + this.getStackTrace().map(stacktrace -> OS.NEWLINE + stacktrace).orElse("");
    }
}

