/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.strings.StringUtil;

public class GroupDescriptions {
    private GroupDescriptions() {
    }

    public static String getShortDescriptionKeywordGroup(KeywordGroup keywordGroup, boolean showDynamic) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        if (showDynamic) {
            sb.append("<i>").append(StringUtil.quoteForHTML(keywordGroup.getName())).append("</i>");
        } else {
            sb.append(StringUtil.quoteForHTML(keywordGroup.getName()));
        }
        sb.append("</b> - ");
        sb.append(Localization.lang("dynamic group", new Object[0]));
        sb.append(" <b>");
        sb.append(keywordGroup.getSearchField());
        sb.append("</b> ");
        sb.append(Localization.lang("contains", new Object[0]));
        sb.append(" <b>");
        sb.append(StringUtil.quoteForHTML(keywordGroup.getSearchExpression()));
        sb.append("</b>)");
        switch (keywordGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new Object[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new Object[0]));
                break;
            }
        }
        return sb.toString();
    }

    public static String getShortDescriptionExplicitGroup(ExplicitGroup explicitGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(explicitGroup.getName()).append("</b> - ").append(Localization.lang("static group", new Object[0]));
        switch (explicitGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new Object[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new Object[0]));
                break;
            }
        }
        return sb.toString();
    }

    public static String getShortDescriptionAllEntriesGroup() {
        return Localization.lang("<b>All Entries</b> (this group cannot be edited or removed)", new Object[0]);
    }

    public static String getShortDescription(SearchGroup searchGroup, boolean showDynamic) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        if (showDynamic) {
            sb.append("<i>").append(StringUtil.quoteForHTML(searchGroup.getName())).append("</i>");
        } else {
            sb.append(StringUtil.quoteForHTML(searchGroup.getName()));
        }
        sb.append("</b> - ");
        sb.append(Localization.lang("dynamic group", new Object[0]));
        sb.append(" (");
        sb.append(Localization.lang("search expression", new Object[0]));
        sb.append(" <b>").append(StringUtil.quoteForHTML(searchGroup.getSearchExpression())).append("</b>)");
        switch (searchGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new Object[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new Object[0]));
                break;
            }
        }
        return sb.toString();
    }
}

