/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.jabref.gui.groups.GroupViewMode;
import org.jabref.gui.icon.IconTheme;
import org.jabref.logic.l10n.Localization;

public class GroupModeViewModel {
    private final GroupViewMode mode;

    public GroupModeViewModel(GroupViewMode mode) {
        this.mode = mode;
    }

    public Node getUnionIntersectionGraphic() {
        if (this.mode == GroupViewMode.UNION) {
            return IconTheme.JabRefIcons.GROUP_UNION.getGraphicNode();
        }
        if (this.mode == GroupViewMode.INTERSECTION) {
            return IconTheme.JabRefIcons.GROUP_INTERSECTION.getGraphicNode();
        }
        return IconTheme.JabRefIcons.GROUP_INTERSECTION.getGraphicNode();
    }

    public Tooltip getUnionIntersectionTooltip() {
        if (this.mode == GroupViewMode.UNION) {
            return new Tooltip(Localization.lang("Toggle intersection", new Object[0]));
        }
        if (this.mode == GroupViewMode.INTERSECTION) {
            return new Tooltip(Localization.lang("Toggle union", new Object[0]));
        }
        return new Tooltip();
    }
}

