/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.icon;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.Size;
import javafx.css.SizeUnits;
import org.jabref.gui.icon.IconTheme;
import org.kordamp.ikonli.javafx.FontIcon;

public class JabRefIconView
extends FontIcon {
    private final ObjectProperty<IconTheme.JabRefIcons> glyph;
    private final ObjectProperty<Number> glyphSize;

    public JabRefIconView(IconTheme.JabRefIcons icon, int size) {
        super(icon.getIkon());
        this.glyph = new SimpleObjectProperty((Object)icon);
        this.glyphSize = new SimpleObjectProperty((Object)size);
        EasyBind.subscribe(this.glyph, glyph -> this.setIconCode(glyph.getIkon()));
        EasyBind.subscribe(this.glyphSize, glyphsize -> this.setIconSize(glyphsize.intValue()));
    }

    public JabRefIconView(IconTheme.JabRefIcons icon) {
        super(icon.getIkon());
        Size size = new Size(1.0, SizeUnits.EM);
        this.glyph = new SimpleObjectProperty((Object)icon);
        this.glyphSize = new SimpleObjectProperty((Object)9);
        int px = (int)size.pixels(this.getFont());
        this.glyphSize.set((Object)px);
        EasyBind.subscribe(this.glyph, glyph -> this.setIconCode(glyph.getIkon()));
        EasyBind.subscribe(this.glyphSize, glyphsize -> this.setIconSize(glyphsize.intValue()));
    }

    public JabRefIconView() {
        this(IconTheme.JabRefIcons.ERROR);
    }

    public IconTheme.JabRefIcons getDefaultGlyph() {
        return IconTheme.JabRefIcons.ERROR;
    }

    public IconTheme.JabRefIcons getGlyph() {
        return (IconTheme.JabRefIcons)this.glyph.get();
    }

    public void setGlyph(IconTheme.JabRefIcons icon) {
        this.glyph.set((Object)icon);
    }

    public ObjectProperty<IconTheme.JabRefIcons> glyphProperty() {
        return this.glyph;
    }

    public void setGlyphSize(Number value) {
        this.glyphSize.set((Object)value);
    }

    public ObjectProperty<Number> glyphSizeProperty() {
        return this.glyphSize;
    }

    public Number getGlyphSize() {
        return (Number)this.glyphSize.getValue();
    }
}

