/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.constants;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.regex.Pattern;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.jabref.logic.l10n.Localization;

public class ConstantsItemModel {
    private static final Pattern IS_NUMBER = Pattern.compile("-?\\d+(\\.\\d+)?");
    private final StringProperty labelProperty = new SimpleStringProperty();
    private final StringProperty contentProperty = new SimpleStringProperty();
    private final Validator labelValidator;
    private final Validator contentValidator;
    private final CompositeValidator combinedValidator;

    public ConstantsItemModel(String label, String content) {
        this.labelProperty.setValue(label);
        this.contentProperty.setValue(content);
        this.labelValidator = new FunctionBasedValidator((ObservableValue)this.labelProperty, ConstantsItemModel::validateLabel);
        this.contentValidator = new FunctionBasedValidator((ObservableValue)this.contentProperty, ConstantsItemModel::validateContent);
        this.combinedValidator = new CompositeValidator(new Validator[]{this.labelValidator, this.contentValidator});
    }

    public ValidationStatus labelValidation() {
        return this.labelValidator.getValidationStatus();
    }

    public ValidationStatus contentValidation() {
        return this.contentValidator.getValidationStatus();
    }

    public ReadOnlyBooleanProperty combinedValidationValidProperty() {
        return this.combinedValidator.getValidationStatus().validProperty();
    }

    public StringProperty labelProperty() {
        return this.labelProperty;
    }

    public StringProperty contentProperty() {
        return this.contentProperty;
    }

    public void setLabel(String label) {
        this.labelProperty.setValue(label);
    }

    public void setContent(String content) {
        this.contentProperty.setValue(content);
    }

    private static ValidationMessage validateLabel(String input) {
        if (input == null) {
            return ValidationMessage.error((String)"May not be null");
        }
        if (input.trim().isEmpty()) {
            return ValidationMessage.error((String)Localization.lang("Please enter the string's label", new Object[0]));
        }
        if (IS_NUMBER.matcher(input).matches()) {
            return ValidationMessage.error((String)Localization.lang("The label of the string cannot be a number.", new Object[0]));
        }
        if (input.contains("#")) {
            return ValidationMessage.error((String)Localization.lang("The label of the string cannot contain the '#' character.", new Object[0]));
        }
        if (input.contains(" ")) {
            return ValidationMessage.error((String)Localization.lang("The label of the string cannot contain spaces.", new Object[0]));
        }
        return null;
    }

    private static ValidationMessage validateContent(String input) {
        if (input == null) {
            return ValidationMessage.error((String)Localization.lang("Must not be empty!", new Object[0]));
        }
        if (input.trim().isEmpty()) {
            return ValidationMessage.error((String)Localization.lang("Must not be empty!", new Object[0]));
        }
        return null;
    }
}

