/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customentrytypes;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.FieldPriority;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.types.EntryType;

public class FieldViewModel {
    private final StringProperty displayName = new SimpleStringProperty("");
    private final BooleanProperty required = new SimpleBooleanProperty();
    private final BooleanProperty multiline = new SimpleBooleanProperty();
    private final ObjectProperty<FieldPriority> priorityProperty = new SimpleObjectProperty();

    public FieldViewModel(Field field, Mandatory required, FieldPriority priorityProperty, boolean multiline) {
        this.displayName.setValue(field.getDisplayName());
        this.required.setValue(Boolean.valueOf(required == Mandatory.REQUIRED));
        this.priorityProperty.setValue((Object)priorityProperty);
        this.multiline.setValue(Boolean.valueOf(multiline));
    }

    public StringProperty displayNameProperty() {
        return this.displayName;
    }

    public BooleanProperty requiredProperty() {
        return this.required;
    }

    public boolean isRequired() {
        return this.required.getValue();
    }

    public BooleanProperty multilineProperty() {
        return this.multiline;
    }

    public boolean isMultiline() {
        return this.multiline.getValue();
    }

    public FieldPriority getPriority() {
        return (FieldPriority)((Object)this.priorityProperty.getValue());
    }

    public Field toField(EntryType type) {
        Field field = FieldFactory.parseField(type, this.displayName.getValue());
        if (this.multiline.getValue().booleanValue()) {
            field.getProperties().add(FieldProperty.MULTILINE_TEXT);
        }
        return field;
    }

    public BibField toBibField(EntryType type) {
        return new BibField(this.toField(type), (FieldPriority)((Object)this.priorityProperty.getValue()));
    }

    public String toString() {
        return this.displayName.getValue();
    }

    public static enum Mandatory {
        REQUIRED(Localization.lang("Required", new Object[0])),
        OPTIONAL(Localization.lang("Optional", new Object[0]));

        private final String name;

        private Mandatory(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

