/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.keybindings;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.keybindings.KeyBindingViewModel;
import org.jabref.gui.preferences.keybindings.KeyBindingsTabViewModel;
import org.jabref.gui.preferences.keybindings.presets.KeyBindingPreset;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.ViewModelTreeTableCellFactory;
import org.jabref.logic.l10n.Localization;

public class KeyBindingsTab
extends AbstractPreferenceTabView<KeyBindingsTabViewModel>
implements PreferencesTab {
    @FXML
    private TreeTableView<KeyBindingViewModel> keyBindingsTable;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, String> actionColumn;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, String> shortcutColumn;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, KeyBindingViewModel> resetColumn;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, KeyBindingViewModel> clearColumn;
    @FXML
    private MenuButton presetsButton;
    @Inject
    private KeyBindingRepository keyBindingRepository;

    public KeyBindingsTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Keyboard shortcuts", new Object[0]);
    }

    @FXML
    private void initialize() {
        this.viewModel = new KeyBindingsTabViewModel(this.keyBindingRepository, this.dialogService, this.preferencesService);
        this.keyBindingsTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        ((KeyBindingsTabViewModel)this.viewModel).selectedKeyBindingProperty().bind((ObservableValue)EasyBind.wrapNullable((ObservableValue)this.keyBindingsTable.selectionModelProperty()).mapObservable(SelectionModel::selectedItemProperty).mapObservable(TreeItem::valueProperty));
        this.keyBindingsTable.setOnKeyPressed(((KeyBindingsTabViewModel)this.viewModel)::setNewBindingForCurrent);
        this.keyBindingsTable.rootProperty().bind((ObservableValue)EasyBind.map(((KeyBindingsTabViewModel)this.viewModel).rootKeyBindingProperty(), keybinding -> new RecursiveTreeItem<KeyBindingViewModel>((KeyBindingViewModel)keybinding, KeyBindingViewModel::getChildren)));
        this.actionColumn.setCellValueFactory(cellData -> ((KeyBindingViewModel)cellData.getValue().getValue()).nameProperty());
        this.shortcutColumn.setCellValueFactory(cellData -> ((KeyBindingViewModel)cellData.getValue().getValue()).shownBindingProperty());
        new ViewModelTreeTableCellFactory().withGraphic(keyBinding -> keyBinding.getResetIcon().map(JabRefIcon::getGraphicNode).orElse(null)).withOnMouseClickedEvent(keyBinding -> evt -> keyBinding.resetToDefault()).install(this.resetColumn);
        new ViewModelTreeTableCellFactory().withGraphic(keyBinding -> keyBinding.getClearIcon().map(JabRefIcon::getGraphicNode).orElse(null)).withOnMouseClickedEvent(keyBinding -> evt -> keyBinding.clear()).install(this.clearColumn);
        ((KeyBindingsTabViewModel)this.viewModel).keyBindingPresets().forEach(preset -> this.presetsButton.getItems().add((Object)this.createMenuItem((KeyBindingPreset)preset)));
    }

    private MenuItem createMenuItem(KeyBindingPreset preset) {
        MenuItem item = new MenuItem(preset.getName());
        item.setOnAction(event -> ((KeyBindingsTabViewModel)this.viewModel).loadPreset(preset));
        return item;
    }

    @FXML
    private void resetBindings() {
        ((KeyBindingsTabViewModel)this.viewModel).resetToDefault();
    }
}

