/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preview;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.externalfiles.ExternalFilesEntryLinker;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPanel
extends VBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPanel.class);
    private final ExternalFilesEntryLinker fileLinker;
    private final KeyBindingRepository keyBindingRepository;
    private final PreviewViewer previewView;
    private final PreviewPreferences previewPreferences;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final IndexingTaskManager indexingTaskManager;
    private BibEntry entry;

    public PreviewPanel(BibDatabaseContext database, DialogService dialogService, KeyBindingRepository keyBindingRepository, PreferencesService preferencesService, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, TaskExecutor taskExecutor) {
        this.keyBindingRepository = keyBindingRepository;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.previewPreferences = preferencesService.getPreviewPreferences();
        this.indexingTaskManager = indexingTaskManager;
        this.fileLinker = new ExternalFilesEntryLinker(preferencesService.getFilePreferences(), database, dialogService);
        PreviewPreferences previewPreferences = preferencesService.getPreviewPreferences();
        this.previewView = new PreviewViewer(database, dialogService, preferencesService, stateManager, themeManager, taskExecutor);
        this.previewView.setLayout(previewPreferences.getSelectedPreviewLayout());
        this.previewView.setContextMenu(this.createPopupMenu());
        this.previewView.setOnDragDetected(event -> {
            this.previewView.startFullDrag();
            Dragboard dragboard = this.previewView.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent content = new ClipboardContent();
            content.putHtml(this.previewView.getSelectionHtmlContent());
            dragboard.setContent((Map)content);
            event.consume();
        });
        this.previewView.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY, TransferMode.MOVE, TransferMode.LINK});
            }
            event.consume();
        });
        this.previewView.setOnDragDropped(event -> {
            boolean success = false;
            if (event.getDragboard().hasContent(DataFormat.FILES)) {
                List<Path> files = event.getDragboard().getFiles().stream().map(File::toPath).collect(Collectors.toList());
                if (event.getTransferMode() == TransferMode.MOVE) {
                    LOGGER.debug("Mode MOVE");
                    this.fileLinker.moveFilesToFileDirRenameAndAddToEntry(this.entry, files, indexingTaskManager);
                }
                if (event.getTransferMode() == TransferMode.LINK) {
                    LOGGER.debug("Node LINK");
                    this.fileLinker.addFilesToEntry(this.entry, files);
                }
                if (event.getTransferMode() == TransferMode.COPY) {
                    LOGGER.debug("Mode Copy");
                    this.fileLinker.copyFilesToFileDirAndAddToEntry(this.entry, files, indexingTaskManager);
                }
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        this.getChildren().add((Object)this.previewView);
        this.createKeyBindings();
        this.previewView.setLayout(previewPreferences.getSelectedPreviewLayout());
    }

    private void createKeyBindings() {
        this.previewView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = this.keyBindingRepository.mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case COPY_PREVIEW: {
                        this.previewView.copyPreviewToClipBoard();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    private ContextMenu createPopupMenu() {
        MenuItem copyPreview = new MenuItem(Localization.lang("Copy preview", new Object[0]), IconTheme.JabRefIcons.COPY.getGraphicNode());
        this.keyBindingRepository.getKeyCombination(KeyBinding.COPY_PREVIEW).ifPresent(arg_0 -> ((MenuItem)copyPreview).setAccelerator(arg_0));
        copyPreview.setOnAction(event -> this.previewView.copyPreviewToClipBoard());
        MenuItem copySelection = new MenuItem(Localization.lang("Copy selection", new Object[0]));
        copySelection.setOnAction(event -> this.previewView.copySelectionToClipBoard());
        MenuItem printEntryPreview = new MenuItem(Localization.lang("Print entry preview", new Object[0]), IconTheme.JabRefIcons.PRINTED.getGraphicNode());
        printEntryPreview.setOnAction(event -> this.previewView.print());
        MenuItem previousPreviewLayout = new MenuItem(Localization.lang("Previous preview layout", new Object[0]));
        this.keyBindingRepository.getKeyCombination(KeyBinding.PREVIOUS_PREVIEW_LAYOUT).ifPresent(arg_0 -> ((MenuItem)previousPreviewLayout).setAccelerator(arg_0));
        previousPreviewLayout.setOnAction(event -> this.previousPreviewStyle());
        MenuItem nextPreviewLayout = new MenuItem(Localization.lang("Next preview layout", new Object[0]));
        this.keyBindingRepository.getKeyCombination(KeyBinding.NEXT_PREVIEW_LAYOUT).ifPresent(arg_0 -> ((MenuItem)nextPreviewLayout).setAccelerator(arg_0));
        nextPreviewLayout.setOnAction(event -> this.nextPreviewStyle());
        ContextMenu menu = new ContextMenu();
        menu.getItems().add((Object)copyPreview);
        menu.getItems().add((Object)copySelection);
        menu.getItems().add((Object)printEntryPreview);
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().add((Object)nextPreviewLayout);
        menu.getItems().add((Object)previousPreviewLayout);
        return menu;
    }

    public void setEntry(BibEntry entry) {
        this.entry = entry;
        this.previewView.setEntry(entry);
        this.previewView.setLayout(this.previewPreferences.getSelectedPreviewLayout());
    }

    public void print() {
        this.previewView.print();
    }

    public void nextPreviewStyle() {
        this.cyclePreview(this.previewPreferences.getLayoutCyclePosition() + 1);
    }

    public void previousPreviewStyle() {
        this.cyclePreview(this.previewPreferences.getLayoutCyclePosition() - 1);
    }

    private void cyclePreview(int newPosition) {
        this.previewPreferences.setLayoutCyclePosition(newPosition);
        PreviewLayout layout = this.previewPreferences.getSelectedPreviewLayout();
        this.previewView.setLayout(layout);
        this.dialogService.notify(Localization.lang("Preview style changed to: %0", layout.getDisplayName()));
    }
}

