/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jabref.logic.exporter.AtomicFileOutputStream;

public class AtomicFileWriter
extends OutputStreamWriter {
    private final CharsetEncoder encoder;
    private final Set<Character> problemCharacters = new TreeSet<Character>();

    public AtomicFileWriter(Path file, Charset encoding) throws IOException {
        this(file, encoding, false);
    }

    public AtomicFileWriter(Path file, Charset encoding, boolean keepBackup) throws IOException {
        super((OutputStream)new AtomicFileOutputStream(file, keepBackup), encoding);
        this.encoder = encoding.newEncoder();
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
        if (!this.encoder.canEncode(str)) {
            for (int i = 0; i < str.length(); ++i) {
                char character = str.charAt(i);
                if (this.encoder.canEncode(character)) continue;
                this.problemCharacters.add(Character.valueOf(character));
            }
        }
    }

    public boolean hasEncodingProblems() {
        return !this.problemCharacters.isEmpty();
    }

    public Set<Character> getEncodingProblems() {
        return Collections.unmodifiableSet(this.problemCharacters);
    }
}

