/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jabref.model.entry.LinkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFieldParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFieldParser.class);
    private final String value;
    private StringBuilder charactersOfCurrentElement;
    private boolean windowsPath;

    public FileFieldParser(String value) {
        this.value = value == null ? null : value.replace("$\\backslash$", "\\");
    }

    public static List<LinkedFile> parse(String value) {
        FileFieldParser fileFieldParser = new FileFieldParser(value);
        return fileFieldParser.parse();
    }

    public List<LinkedFile> parse() {
        ArrayList<LinkedFile> files = new ArrayList<LinkedFile>();
        if (this.value == null || this.value.trim().isEmpty()) {
            return files;
        }
        if (LinkedFile.isOnlineLink(this.value.trim())) {
            try {
                return List.of(new LinkedFile(new URL(this.value), ""));
            }
            catch (MalformedURLException e) {
                LOGGER.error("invalid url", (Throwable)e);
                return files;
            }
        }
        ArrayList<String> linkedFileData = new ArrayList<String>();
        this.resetDataStructuresForNextElement();
        boolean inXmlChar = false;
        boolean escaped = false;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (!escaped && c == '\\') {
                if (this.windowsPath) {
                    this.charactersOfCurrentElement.append(c);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (!escaped && c == '&' && !inXmlChar) {
                this.charactersOfCurrentElement.append(c);
                if (this.value.length() > i + 1 && this.value.charAt(i + 1) == '#') {
                    inXmlChar = true;
                }
            } else if (!escaped && inXmlChar && c == ';') {
                this.charactersOfCurrentElement.append(c);
                inXmlChar = false;
            } else if (!escaped && c == ':') {
                if (linkedFileData.size() == 1 && this.charactersOfCurrentElement.length() == 1) {
                    this.charactersOfCurrentElement.append(c);
                    this.windowsPath = true;
                } else if (this.charactersOfCurrentElement.length() == 1 && this.value.charAt(i + 1) == '\\') {
                    this.charactersOfCurrentElement.append(c);
                    this.windowsPath = true;
                } else {
                    linkedFileData.add(this.charactersOfCurrentElement.toString());
                    this.resetDataStructuresForNextElement();
                }
            } else if (!escaped && c == ';' && !inXmlChar) {
                linkedFileData.add(this.charactersOfCurrentElement.toString());
                files.add(FileFieldParser.convert(linkedFileData));
                this.resetDataStructuresForNextElement();
            } else {
                this.charactersOfCurrentElement.append(c);
            }
            escaped = false;
        }
        if (this.charactersOfCurrentElement.length() > 0) {
            linkedFileData.add(this.charactersOfCurrentElement.toString());
        }
        if (!linkedFileData.isEmpty()) {
            files.add(FileFieldParser.convert(linkedFileData));
        }
        return files;
    }

    private void resetDataStructuresForNextElement() {
        this.charactersOfCurrentElement = new StringBuilder();
        this.windowsPath = false;
    }

    static LinkedFile convert(List<String> entry) {
        while (entry.size() < 3) {
            entry.add("");
        }
        LinkedFile field = null;
        if (LinkedFile.isOnlineLink(entry.get(1))) {
            try {
                field = new LinkedFile(entry.getFirst(), new URL(entry.get(1)), entry.get(2));
            }
            catch (MalformedURLException e) {
                field = new LinkedFile(entry.getFirst(), entry.get(1), entry.get(2));
            }
        } else {
            String pathStr = entry.get(1);
            if (pathStr.contains("//")) {
                field = new LinkedFile(entry.getFirst(), pathStr, entry.get(2));
            } else {
                try {
                    field = new LinkedFile(entry.getFirst(), Path.of(pathStr, new String[0]), entry.get(2));
                }
                catch (InvalidPathException e) {
                    LOGGER.debug("Invalid path object, continuing with string", (Throwable)e);
                    field = new LinkedFile(entry.getFirst(), pathStr, entry.get(2));
                }
            }
        }
        if (entry.size() > 3) {
            field.setSourceURL(entry.get(3));
        }
        if (field.getDescription().isEmpty() && field.getLink().isEmpty() && !field.getFileType().isEmpty()) {
            field = new LinkedFile("", Path.of(field.getFileType(), new String[0]), "");
        } else if (!field.getDescription().isEmpty() && field.getLink().isEmpty() && field.getFileType().isEmpty()) {
            field = new LinkedFile("", Path.of(field.getDescription(), new String[0]), "");
        }
        entry.clear();
        return field;
    }
}

