/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ARK;
import org.jabref.model.entry.identifier.ArXivIdentifier;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.model.entry.identifier.Identifier;
import org.jabref.model.entry.identifier.MathSciNetId;
import org.jabref.model.strings.StringUtil;

public class IdentifierParser {
    private final BibEntry entry;

    public IdentifierParser(BibEntry entry) {
        Objects.requireNonNull(entry);
        this.entry = entry;
    }

    public Optional<? extends Identifier> parse(Field field) {
        String fieldValue = this.entry.getField(field).orElse("");
        if (StringUtil.isBlank(fieldValue)) {
            return Optional.empty();
        }
        if (StandardField.DOI == field) {
            return DOI.parse(fieldValue);
        }
        if (StandardField.ISBN == field) {
            return ISBN.parse(fieldValue);
        }
        if (StandardField.EPRINT == field) {
            return this.parseEprint(fieldValue);
        }
        if (StandardField.MR_NUMBER == field) {
            return MathSciNetId.parse(fieldValue);
        }
        return Optional.empty();
    }

    private Optional<? extends Identifier> parseEprint(String eprint) {
        Optional<String> archivePrefixOpt;
        Optional<String> eprintTypeOpt = this.entry.getField(StandardField.EPRINTTYPE);
        String eprintType = eprintTypeOpt.or(() -> IdentifierParser.lambda$parseEprint$0(archivePrefixOpt = this.entry.getField(StandardField.ARCHIVEPREFIX))).orElse("");
        if ("arxiv".equalsIgnoreCase(eprintType)) {
            return ArXivIdentifier.parse(eprint);
        }
        if ("ark".equalsIgnoreCase(eprintType)) {
            return ARK.parse(eprint);
        }
        return Optional.empty();
    }

    private static /* synthetic */ Optional lambda$parseEprint$0(Optional archivePrefixOpt) {
        return archivePrefixOpt;
    }
}

