/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.strings.StringUtil;

public class TitleChecker
implements ValueChecker {
    private static final Pattern INSIDE_CURLY_BRAKETS = Pattern.compile("\\{[^}\\{]*\\}");
    private static final Pattern DELIMITERS = Pattern.compile("\\.|\\!|\\?|\\;|\\:|\\[");
    private static final Predicate<String> HAS_CAPITAL_LETTERS = Pattern.compile("[\\p{Lu}\\p{Lt}]").asPredicate();
    private final BibDatabaseContext databaseContext;

    public TitleChecker(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
    }

    @Override
    public Optional<String> checkValue(String value) {
        String[] splitTitle;
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        if (this.databaseContext.isBiblatexMode()) {
            return Optional.empty();
        }
        String valueOnlySpacesWithinCurlyBraces = INSIDE_CURLY_BRAKETS.matcher(value).replaceAll("");
        for (String subTitle : splitTitle = DELIMITERS.split(valueOnlySpacesWithinCurlyBraces)) {
            if ((subTitle = subTitle.trim()).isEmpty() || !HAS_CAPITAL_LETTERS.test(subTitle = subTitle.substring(1))) continue;
            return Optional.of(Localization.lang("capital letters are not masked using curly brackets {}", new Object[0]));
        }
        return Optional.empty();
    }
}

