/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf.search;

import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;

public class IndexingTaskManager
extends BackgroundTask<Void> {
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    private TaskExecutor taskExecutor;
    private int numOfIndexedFiles = 0;
    private final Object lock = new Object();
    private boolean isRunning = false;
    private boolean isBlockingNewTasks = false;

    public IndexingTaskManager(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        this.showToUser(true);
        this.willBeRecoveredAutomatically(true);
        this.updateProgress(1.0, 1.0);
        this.titleProperty().set((Object)Localization.lang("Indexing pdf files", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void call() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = true;
        }
        this.updateProgress();
        while (!this.taskQueue.isEmpty() && !this.isCanceled()) {
            this.taskQueue.poll().run();
            ++this.numOfIndexedFiles;
            this.updateProgress();
        }
        object = this.lock;
        synchronized (object) {
            this.isRunning = false;
        }
        return null;
    }

    private void updateProgress() {
        this.updateMessage(Localization.lang("%0 of %1 linked files added to the index", this.numOfIndexedFiles, this.numOfIndexedFiles + this.taskQueue.size()));
        this.updateProgress(this.numOfIndexedFiles, this.numOfIndexedFiles + this.taskQueue.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueTask(Runnable indexingTask) {
        if (!this.isBlockingNewTasks) {
            this.taskQueue.add(indexingTask);
            Object object = this.lock;
            synchronized (object) {
                if (!this.isRunning) {
                    this.isRunning = true;
                    this.executeWith(this.taskExecutor);
                    this.showToUser(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoCloseable blockNewTasks() {
        Object object = this.lock;
        synchronized (object) {
            this.isBlockingNewTasks = true;
        }
        return () -> {
            Object object = this.lock;
            synchronized (object) {
                this.isBlockingNewTasks = false;
            }
        };
    }

    public void rebuildIndex(PdfIndexer indexer) {
        this.enqueueTask(indexer::rebuildIndex);
    }

    public void updateIndex(PdfIndexer indexer, BibDatabaseContext databaseContext) {
        Set<String> pathsToRemove = indexer.getListOfFilePaths();
        databaseContext.getEntries().stream().flatMap(entry -> entry.getFiles().stream()).map(LinkedFile::getLink).forEach(pathsToRemove::remove);
        this.addToIndex(indexer, databaseContext.getEntries());
        this.enqueueTask(() -> indexer.removePathsFromIndex(pathsToRemove));
    }

    public void addToIndex(PdfIndexer indexer, List<BibEntry> entries) {
        AtomicInteger counter = new AtomicInteger();
        entries.stream().collect(Collectors.groupingBy(x -> counter.getAndIncrement() / 50)).values().forEach(list -> this.enqueueTask(() -> indexer.addToIndex((List<BibEntry>)list)));
    }

    public void addToIndex(PdfIndexer indexer, BibEntry entry) {
        this.enqueueTask(() -> indexer.addToIndex(entry));
    }

    public void addToIndex(PdfIndexer indexer, BibEntry entry, List<LinkedFile> linkedFiles) {
        this.enqueueTask(() -> indexer.addToIndex(entry, linkedFiles));
    }

    public void removeFromIndex(PdfIndexer indexer, BibEntry entry) {
        this.enqueueTask(() -> indexer.removeFromIndex(entry));
    }

    public void removeFromIndex(PdfIndexer indexer, List<LinkedFile> linkedFiles) {
        this.enqueueTask(() -> indexer.removeFromIndex(linkedFiles));
    }

    public void updateDatabaseName(String name) {
        UiTaskExecutor.runInJavaFXThread(() -> this.titleProperty().set((Object)Localization.lang("Indexing for %0", name)));
    }
}

