/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared;

import java.util.Arrays;
import java.util.Optional;

public enum DBMSType {
    POSTGRESQL("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://%s:%d/%s", 5432),
    MYSQL("MySQL", "org.mariadb.jdbc.Driver", "jdbc:mariadb://%s:%d/%s", 3306),
    ORACLE("Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@%s:%d/%s", 1521);

    private final String type;
    private final String driverPath;
    private String urlPattern;
    private final int defaultPort;

    private DBMSType(String type, String driverPath, String urlPattern, int defaultPort) {
        this.type = type;
        this.driverPath = driverPath;
        this.urlPattern = urlPattern;
        this.defaultPort = defaultPort;
    }

    public static Optional<DBMSType> fromString(String typeName) {
        return Arrays.stream(DBMSType.values()).filter(dbmsType -> dbmsType.type.equalsIgnoreCase(typeName)).findAny();
    }

    public String toString() {
        return this.type;
    }

    public String getDriverClassPath() throws Error {
        return this.driverPath;
    }

    public String getUrl(String host, int port, String database) {
        return this.urlPattern.formatted(host, port, database);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }
}

