/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jabref.model.entry.field.AMSField;
import org.jabref.model.entry.field.BiblatexApaField;
import org.jabref.model.entry.field.BiblatexSoftwareField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.IEEEField;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.field.UserSpecificCommentField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.OptionalUtil;

public class FieldFactory {
    private static final String FIELD_OR_SEPARATOR = "/";
    private static final String DELIMITER = ";";

    public static String serializeOrFields(Field ... fields) {
        return FieldFactory.serializeOrFields(new OrFields(fields));
    }

    public static String serializeOrFields(OrFields fields) {
        return fields.getFields().stream().map(field -> {
            if (field instanceof UnknownField) {
                UnknownField unknownField = (UnknownField)field;
                return unknownField.getDisplayName();
            }
            return field.getName();
        }).collect(Collectors.joining(FIELD_OR_SEPARATOR));
    }

    public static String serializeOrFieldsList(Set<OrFields> fields) {
        return fields.stream().map(FieldFactory::serializeOrFields).collect(Collectors.joining(DELIMITER));
    }

    public static boolean isLatexField(Field field) {
        return Collections.disjoint(field.getProperties(), Set.of(FieldProperty.VERBATIM, FieldProperty.MARKDOWN));
    }

    public static Collection<Field> getNotTextFields() {
        Set<Field> result = Arrays.stream(StandardField.values()).filter(field -> !Collections.disjoint(field.getProperties(), Set.of(FieldProperty.VERBATIM, FieldProperty.NUMERIC, FieldProperty.DATE, FieldProperty.MULTIPLE_ENTRY_LINK))).collect(Collectors.toSet());
        result.add(StandardField.MONTH);
        result.add(StandardField.DATE);
        return result;
    }

    public static OrFields parseOrFields(String fieldNames) {
        Set fields = Arrays.stream(fieldNames.split(FIELD_OR_SEPARATOR)).filter(StringUtil::isNotBlank).map(FieldFactory::parseField).collect(Collectors.toCollection(LinkedHashSet::new));
        return new OrFields(fields);
    }

    public static SequencedSet<OrFields> parseOrFieldsList(String fieldNames) {
        return Arrays.stream(fieldNames.split(DELIMITER)).filter(StringUtil::isNotBlank).map(FieldFactory::parseOrFields).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static SequencedSet<Field> parseFieldList(String fieldNames) {
        return Arrays.stream(fieldNames.split(DELIMITER)).filter(StringUtil::isNotBlank).map(FieldFactory::parseField).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static String serializeFieldsList(Collection<Field> fields) {
        return fields.stream().map(field -> {
            if (field instanceof UnknownField) {
                UnknownField unknownField = (UnknownField)field;
                return unknownField.getDisplayName();
            }
            return field.getName();
        }).collect(Collectors.joining(DELIMITER));
    }

    public static <T extends EntryType> Field parseField(T type, String fieldName) {
        if (fieldName.startsWith("comment-")) {
            String username = fieldName.substring("comment-".length());
            return new UserSpecificCommentField(username);
        }
        return OptionalUtil.orElse(OptionalUtil.orElse(OptionalUtil.orElse(OptionalUtil.orElse(OptionalUtil.orElse(OptionalUtil.orElse(InternalField.fromName(fieldName), StandardField.fromName(fieldName)), SpecialField.fromName(fieldName)), IEEEField.fromName(fieldName)), BiblatexSoftwareField.fromName(type, fieldName)), BiblatexApaField.fromName(type, fieldName)), AMSField.fromName(type, fieldName)).orElse((AMSField)((Object)UnknownField.fromDisplayName(fieldName)));
    }

    public static Field parseField(String fieldName) {
        return FieldFactory.parseField(null, fieldName);
    }

    public static boolean isInternalField(Field field) {
        return field.getName().startsWith("__");
    }

    public static Set<Field> getJournalNameFields() {
        return FieldFactory.getFieldsFiltered(field -> field.getProperties().contains((Object)FieldProperty.JOURNAL_NAME));
    }

    public static Set<Field> getCommonFields() {
        EnumSet<StandardField> allFields = EnumSet.allOf(StandardField.class);
        LinkedHashSet<Field> publicAndInternalFields = new LinkedHashSet<Field>(allFields.size() + 3);
        publicAndInternalFields.add(InternalField.INTERNAL_ALL_FIELD);
        publicAndInternalFields.add(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD);
        publicAndInternalFields.add(InternalField.KEY_FIELD);
        publicAndInternalFields.addAll(allFields);
        return publicAndInternalFields;
    }

    public static Set<Field> getAllFieldsWithOutInternal() {
        TreeSet<Field> fields = new TreeSet<Field>(Comparator.comparing(Field::getDisplayName));
        fields.addAll(FieldFactory.getAllFields());
        fields.removeAll(EnumSet.allOf(InternalField.class));
        return fields;
    }

    public static SequencedSet<Field> getStandardFieldsWithCitationKey() {
        EnumSet<StandardField> allFields = EnumSet.allOf(StandardField.class);
        LinkedHashSet<Field> standardFieldsWithBibtexKey = new LinkedHashSet<Field>(allFields.size() + 1);
        standardFieldsWithBibtexKey.add(InternalField.KEY_FIELD);
        standardFieldsWithBibtexKey.addAll(allFields);
        return standardFieldsWithBibtexKey;
    }

    public static Set<Field> getBookNameFields() {
        return FieldFactory.getFieldsFiltered(field -> field.getProperties().contains((Object)FieldProperty.BOOK_NAME));
    }

    public static Set<Field> getPersonNameFields() {
        return FieldFactory.getFieldsFiltered(field -> field.getProperties().contains((Object)FieldProperty.PERSON_NAMES));
    }

    private static Set<Field> getFieldsFiltered(Predicate<Field> selector) {
        return FieldFactory.getAllFields().stream().filter(selector).collect(Collectors.toSet());
    }

    private static Set<Field> getAllFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(EnumSet.allOf(BiblatexApaField.class));
        fields.addAll(EnumSet.allOf(BiblatexSoftwareField.class));
        fields.addAll(EnumSet.allOf(IEEEField.class));
        fields.addAll(EnumSet.allOf(InternalField.class));
        fields.addAll(EnumSet.allOf(SpecialField.class));
        fields.addAll(EnumSet.allOf(StandardField.class));
        return fields;
    }

    public static List<Field> getDefaultGeneralFields() {
        ArrayList<Field> defaultGeneralFields = new ArrayList<Field>(Arrays.asList(StandardField.DOI, StandardField.CROSSREF, StandardField.KEYWORDS, StandardField.EPRINT, StandardField.URL, StandardField.FILE, StandardField.GROUPS, StandardField.OWNER, StandardField.TIMESTAMP));
        defaultGeneralFields.addAll(EnumSet.allOf(SpecialField.class));
        return defaultGeneralFields;
    }

    public static boolean isMultiLineField(Field field, List<Field> nonWrappableFields) {
        return field.getProperties().contains((Object)FieldProperty.MULTILINE_TEXT) || nonWrappableFields.contains(field);
    }
}

