/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.CompoundItemDataProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.bibtex.BibTeXItemDataProvider;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.endnote.EndNoteConverter;
import de.undercouch.citeproc.endnote.EndNoteItemDataProvider;
import de.undercouch.citeproc.endnote.EndNoteLibrary;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.ris.RISConverter;
import de.undercouch.citeproc.ris.RISItemDataProvider;
import de.undercouch.citeproc.ris.RISLibrary;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.ParseException;
import org.yaml.snakeyaml.Yaml;

public class BibliographyFileReader {
    public ItemDataProvider readBibliographyFile(File bibfile) throws FileNotFoundException, IOException {
        if (!bibfile.exists()) {
            throw new FileNotFoundException("Bibliography file `" + bibfile.getName() + "' does not exist");
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(bibfile));){
            ItemDataProvider itemDataProvider = this.readBibliographyFile((InputStream)bis, bibfile.getName());
            return itemDataProvider;
        }
    }

    public ItemDataProvider readBibliographyFile(InputStream bibstream, String filename) throws IOException {
        BufferedInputStream bis = bibstream instanceof BufferedInputStream ? (BufferedInputStream)bibstream : new BufferedInputStream(bibstream);
        FileFormat ff = this.determineFileFormat(bis, filename);
        return this.readBibliographyFile((InputStream)bis, ff);
    }

    public ItemDataProvider readBibliographyFile(InputStream bibstream, FileFormat format) throws IOException {
        ItemDataProvider provider;
        block12: {
            try {
                if (format == FileFormat.BIBTEX) {
                    BibTeXDatabase db = new BibTeXConverter().loadDatabase(bibstream);
                    BibTeXItemDataProvider bibtexprovider = new BibTeXItemDataProvider();
                    bibtexprovider.addDatabase(db);
                    provider = bibtexprovider;
                    break block12;
                }
                if (format == FileFormat.JSON_ARRAY || format == FileFormat.JSON_OBJECT) {
                    List<Object> objs;
                    JsonParser parser = new JsonParser(new JsonLexer(new InputStreamReader(bibstream, StandardCharsets.UTF_8)));
                    if (format == FileFormat.JSON_ARRAY) {
                        objs = parser.parseArray();
                    } else {
                        objs = new ArrayList<Object>();
                        objs.add(parser.parseObject());
                    }
                    CSLItemData[] items = new CSLItemData[objs.size()];
                    for (int i = 0; i < items.length; ++i) {
                        Map obj = (Map)objs.get(i);
                        items[i] = CSLItemData.fromJson(obj);
                    }
                    provider = new ListItemDataProvider(items);
                    break block12;
                }
                if (format == FileFormat.YAML) {
                    Yaml yaml = new Yaml();
                    Iterable documentsIterable = yaml.loadAll(bibstream);
                    ArrayList documents = new ArrayList();
                    documentsIterable.forEach(o -> {
                        if (o instanceof Map) {
                            documents.add(Collections.singletonList(o));
                        } else {
                            documents.add(new ArrayList((Collection)o));
                        }
                    });
                    ArrayList<ItemDataProvider> providers = new ArrayList<ItemDataProvider>();
                    for (List objs : documents) {
                        CSLItemData[] items = new CSLItemData[objs.size()];
                        for (int i = 0; i < items.length; ++i) {
                            Map obj = (Map)objs.get(i);
                            items[i] = CSLItemData.fromJson(obj);
                        }
                        ListItemDataProvider p = new ListItemDataProvider(items);
                        providers.add(p);
                    }
                    provider = providers.size() == 1 ? (ItemDataProvider)providers.get(0) : new CompoundItemDataProvider(providers);
                    break block12;
                }
                if (format == FileFormat.ENDNOTE) {
                    EndNoteLibrary lib = new EndNoteConverter().loadLibrary(bibstream);
                    EndNoteItemDataProvider endnoteprovider = new EndNoteItemDataProvider();
                    endnoteprovider.addLibrary(lib);
                    provider = endnoteprovider;
                    break block12;
                }
                if (format == FileFormat.RIS) {
                    RISLibrary lib = new RISConverter().loadLibrary(bibstream);
                    RISItemDataProvider risprovider = new RISItemDataProvider();
                    risprovider.addLibrary(lib);
                    provider = risprovider;
                    break block12;
                }
                throw new IOException("Unknown bibliography file format");
            }
            catch (ParseException e) {
                throw new IOException("Could not parse bibliography file", e);
            }
        }
        return provider;
    }

    public FileFormat determineFileFormat(File bibfile) throws FileNotFoundException, IOException {
        if (!bibfile.exists()) {
            throw new FileNotFoundException("Bibliography file `" + bibfile.getName() + "' does not exist");
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(bibfile));){
            FileFormat fileFormat = this.determineFileFormat(bis, bibfile.getName());
            return fileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileFormat determineFileFormat(BufferedInputStream bis, String filename) throws IOException {
        int dot;
        int len = 102400;
        String ext = "";
        if (filename != null && (dot = filename.lastIndexOf(46)) > 0) {
            ext = filename.substring(dot + 1);
        }
        bis.mark(len);
        try {
            byte[] firstCharacters = new byte[6];
            bis.read(firstCharacters);
            if (firstCharacters[0] == 37 && firstCharacters[1] == 89 && firstCharacters[2] == 65 && firstCharacters[3] == 77 && firstCharacters[4] == 76 && Character.isWhitespace(firstCharacters[5])) {
                FileFormat fileFormat = FileFormat.YAML;
                return fileFormat;
            }
            if (firstCharacters[0] == 37 && Character.isWhitespace(firstCharacters[2]) && !ext.equalsIgnoreCase("bib") && !ext.equalsIgnoreCase("yaml") && !ext.equalsIgnoreCase("yml")) {
                FileFormat fileFormat = FileFormat.ENDNOTE;
                return fileFormat;
            }
            if (firstCharacters[0] == 84 && firstCharacters[1] == 89 && Character.isWhitespace(firstCharacters[2]) && Character.isWhitespace(firstCharacters[3]) && firstCharacters[4] == 45) {
                FileFormat fileFormat = FileFormat.RIS;
                return fileFormat;
            }
        }
        finally {
            bis.reset();
        }
        bis.mark(len);
        try {
            while (true) {
                int c;
                if ((c = bis.read()) < 0 || --len < 2) {
                    FileFormat fileFormat = FileFormat.UNKNOWN;
                    return fileFormat;
                }
                if (Character.isWhitespace(c)) continue;
                if (c == 91) {
                    FileFormat fileFormat = FileFormat.JSON_ARRAY;
                    return fileFormat;
                }
                if (c == 123) {
                    FileFormat fileFormat = FileFormat.JSON_OBJECT;
                    return fileFormat;
                }
                if (ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml")) {
                    FileFormat fileFormat = FileFormat.YAML;
                    return fileFormat;
                }
                FileFormat fileFormat = FileFormat.BIBTEX;
                return fileFormat;
            }
        }
        finally {
            bis.reset();
        }
    }

    public static enum FileFormat {
        BIBTEX,
        JSON_OBJECT,
        JSON_ARRAY,
        YAML,
        ENDNOTE,
        RIS,
        UNKNOWN;

    }
}

