/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.StyledDocument;

public class MultiChangeBuilder<PS, SEG, S> {
    private final GenericStyledArea<PS, SEG, S> area;
    private final List<Replacement<PS, SEG, S>> list;
    private boolean alreadyCreated = false;

    MultiChangeBuilder(GenericStyledArea<PS, SEG, S> area) {
        this(area, new ArrayList<Replacement<PS, SEG, S>>());
    }

    MultiChangeBuilder(GenericStyledArea<PS, SEG, S> area, int initialListSize) {
        this(area, new ArrayList<Replacement<PS, SEG, S>>(initialListSize));
    }

    private MultiChangeBuilder(GenericStyledArea<PS, SEG, S> area, List<Replacement<PS, SEG, S>> list) {
        this.area = area;
        this.list = list;
    }

    public MultiChangeBuilder<PS, SEG, S> insertText(int position, String text) {
        return this.replaceText(position, position, text);
    }

    public MultiChangeBuilder<PS, SEG, S> insertTextAbsolutely(int position, String text) {
        return this.replaceTextAbsolutely(position, position, text);
    }

    public MultiChangeBuilder<PS, SEG, S> insertText(int paragraphIndex, int columnPosition, String text) {
        int index = this.area.getAbsolutePosition(paragraphIndex, columnPosition);
        return this.replaceText(index, index, text);
    }

    public MultiChangeBuilder<PS, SEG, S> insertTextAbsolutely(int paragraphIndex, int columnPosition, String text) {
        int index = this.area.getAbsolutePosition(paragraphIndex, columnPosition);
        return this.replaceTextAbsolutely(index, index, text);
    }

    public MultiChangeBuilder<PS, SEG, S> insert(int position, StyledDocument<PS, SEG, S> document) {
        return this.replace(position, position, document);
    }

    public MultiChangeBuilder<PS, SEG, S> insertAbsolutely(int position, StyledDocument<PS, SEG, S> document) {
        return this.replaceAbsolutely(position, position, document);
    }

    public MultiChangeBuilder<PS, SEG, S> insert(int paragraphIndex, int columnPosition, StyledDocument<PS, SEG, S> document) {
        int pos = this.area.getAbsolutePosition(paragraphIndex, columnPosition);
        return this.replace(pos, pos, document);
    }

    public MultiChangeBuilder<PS, SEG, S> insertAbsolutely(int paragraphIndex, int columnPosition, StyledDocument<PS, SEG, S> document) {
        int pos = this.area.getAbsolutePosition(paragraphIndex, columnPosition);
        return this.replaceAbsolutely(pos, pos, document);
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(IndexRange range) {
        return this.deleteText(range.getStart(), range.getEnd());
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(IndexRange range) {
        return this.deleteTextAbsolutely(range.getStart(), range.getEnd());
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(int start, int end) {
        return this.replaceText(start, end, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(int start, int end) {
        return this.replaceTextAbsolutely(start, end, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.area.getAbsolutePosition(startParagraph, startColumn);
        int end = this.area.getAbsolutePosition(endParagraph, endColumn);
        return this.replaceText(start, end, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.area.getAbsolutePosition(startParagraph, startColumn);
        int end = this.area.getAbsolutePosition(endParagraph, endColumn);
        return this.replaceTextAbsolutely(start, end, "");
    }

    public MultiChangeBuilder<PS, SEG, S> replaceText(int start, int end, String text) {
        return this.relativeReplace(start, end, ReadOnlyStyledDocument.fromString(text, this.area.getInitialParagraphStyle(), this.area.getInitialTextStyle(), this.area.getSegOps()));
    }

    public MultiChangeBuilder<PS, SEG, S> replaceTextAbsolutely(int start, int end, String text) {
        return this.absoluteReplace(start, end, ReadOnlyStyledDocument.fromString(text, this.area.getInitialParagraphStyle(), this.area.getInitialTextStyle(), this.area.getSegOps()));
    }

    public MultiChangeBuilder<PS, SEG, S> replace(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        return this.relativeReplace(start, end, ReadOnlyStyledDocument.from(replacement));
    }

    public MultiChangeBuilder<PS, SEG, S> replaceAbsolutely(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        return this.absoluteReplace(start, end, ReadOnlyStyledDocument.from(replacement));
    }

    public final void commit() {
        this.ensureNotYetCreated();
        this.ensureHasChanges();
        this.alreadyCreated = true;
        this.area.replaceMulti(Collections.unmodifiableList(this.list));
    }

    private MultiChangeBuilder<PS, SEG, S> relativeReplace(int start, int end, ReadOnlyStyledDocument<PS, SEG, S> replacement) {
        if (this.list.isEmpty()) {
            return this.absoluteReplace(start, end, replacement);
        }
        int realStart = start;
        int realEnd = end;
        for (Replacement<PS, SEG, S> r : this.list) {
            if (r.getStart() <= realStart) {
                realStart += r.getNetLength();
                if (r.getEnd() > realEnd) continue;
                realEnd += r.getNetLength();
                continue;
            }
            if (r.getEnd() > realEnd) continue;
            realEnd += r.getNetLength();
        }
        return this.absoluteReplace(realStart, realEnd, replacement);
    }

    private MultiChangeBuilder<PS, SEG, S> absoluteReplace(int start, int end, ReadOnlyStyledDocument<PS, SEG, S> replacement) {
        this.list.add(new Replacement<PS, SEG, S>(start, end, replacement));
        return this;
    }

    private void ensureNotYetCreated() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Cannot reuse a builder multiple times");
        }
    }

    private void ensureHasChanges() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Cannot commit multiple changes since none have been added");
        }
    }

    public boolean hasChanges() {
        return this.list.size() > 0;
    }
}

