/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetSetter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

public class BeanSetPropertyField<M, E, T extends ObservableSet<E>, R extends Property<T>>
implements PropertyField<T, M, R> {
    private final SetGetter<M, E> getter;
    private final SetSetter<M, E> setter;
    private Set<E> defaultValue;
    private final SetProperty<E> targetProperty;

    public BeanSetPropertyField(SideEffect updateFunction, SetGetter<M, E> getter, SetSetter<M, E> setter, Supplier<SetProperty<E>> propertySupplier) {
        this(updateFunction, getter, setter, propertySupplier, Collections.emptySet());
    }

    public BeanSetPropertyField(SideEffect updateFunction, SetGetter<M, E> getter, SetSetter<M, E> setter, Supplier<SetProperty<E>> propertySupplier, Set<E> defaultValue) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.setter = setter;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableSet(new HashSet()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    static <E> void setAll(Set<E> target, Set<E> newValues) {
        target.retainAll(newValues);
        target.addAll(newValues);
    }

    @Override
    public void commit(M wrappedObject) {
        this.setter.accept(wrappedObject, (Set<E>)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanSetPropertyField.setAll(this.targetProperty, this.getter.apply((Object)wrappedObject));
    }

    @Override
    public void resetToDefault() {
        BeanSetPropertyField.setAll(this.targetProperty, this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashSet(this.getter.apply((Object)wrappedObject));
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        SetProperty<E> wrapperValue;
        Object modelValue = this.getter.apply((Object)wrappedObject);
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

